/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub;

import com.codecademy.eventhub.index.DatedEventIndex;
import com.codecademy.eventhub.index.EventIndex;
import com.codecademy.eventhub.index.PropertiesIndex;
import com.codecademy.eventhub.index.ShardedEventIndex;
import com.codecademy.eventhub.index.UserEventIndex;
import com.codecademy.eventhub.list.DummyIdList;
import com.codecademy.eventhub.list.IdList;
import com.codecademy.eventhub.list.MemIdList;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.EventStorage;
import com.codecademy.eventhub.storage.UserStorage;
import com.codecademy.eventhub.storage.filter.Filter;
import com.codecademy.eventhub.storage.filter.TrueFilter;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class EventHub
implements Closeable {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private final String directory;
    private final ShardedEventIndex shardedEventIndex;
    private final DatedEventIndex datedEventIndex;
    private final PropertiesIndex propertiesIndex;
    private final UserEventIndex userEventIndex;
    private final EventStorage eventStorage;
    private final UserStorage userStorage;

    public EventHub(String directory, ShardedEventIndex shardedEventIndex, DatedEventIndex datedEventIndex, PropertiesIndex propertiesIndex, UserEventIndex userEventIndex, EventStorage eventStorage, UserStorage userStorage) {
        this.directory = directory;
        this.shardedEventIndex = shardedEventIndex;
        this.datedEventIndex = datedEventIndex;
        this.propertiesIndex = propertiesIndex;
        this.userEventIndex = userEventIndex;
        this.eventStorage = eventStorage;
        this.userStorage = userStorage;
    }

    public int[][] getRetentionTable(String startDateString, String endDateString, int numDaysPerCohort, int numColumns, String rowEventType, String columnEventType, Filter rowEventFilter, Filter columnEventFilter) {
        int i;
        DateTime startDate = DATE_TIME_FORMATTER.parseDateTime(startDateString);
        DateTime endDate = DATE_TIME_FORMATTER.parseDateTime(endDateString);
        int numRows = (Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getDays() + 1) / numDaysPerCohort;
        List<Set<Integer>> rowIdSets = this.getUserIdsSets(rowEventType, startDate, rowEventFilter, numDaysPerCohort, numRows);
        List<Set<Integer>> columnIdSets = this.getUserIdsSets(columnEventType, startDate, columnEventFilter, numDaysPerCohort, numColumns + numRows);
        ArrayTable retentionTable = ArrayTable.create((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(numRows)), (DiscreteDomain)DiscreteDomain.integers()), (Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(numColumns + 1)), (DiscreteDomain)DiscreteDomain.integers()));
        retentionTable.put((Object)0, (Object)0, (Object)0);
        for (i = 0; i < numRows; ++i) {
            retentionTable.put((Object)i, (Object)0, (Object)rowIdSets.get(i).size());
        }
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                Set<Integer> rowSet = rowIdSets.get(i);
                Set<Integer> columnSet = columnIdSets.get(j + i);
                int count = 0;
                for (Integer columnValue : columnSet) {
                    if (!rowSet.contains(columnValue)) continue;
                    ++count;
                }
                retentionTable.put((Object)i, (Object)(j + 1), (Object)count);
            }
        }
        int[][] result = new int[numRows][numColumns + 1];
        for (int i2 = 0; i2 < numRows; ++i2) {
            for (int j = 0; j < numColumns + 1; ++j) {
                result[i2][j] = (Integer)retentionTable.get((Object)i2, (Object)j);
            }
        }
        return result;
    }

    public synchronized int[] getFunnelCounts(String startDate, String endDate, String[] funnelStepsEventTypes, int numDaysToCompleteFunnel, List<Filter> eventFilters, Filter userFilter) {
        MemIdList firstStepEventIdList = new MemIdList(new long[10000], 0);
        int[] funnelStepsEventTypeIds = this.getEventTypeIds(funnelStepsEventTypes);
        ArrayList userIdsList = Lists.newArrayList();
        HashSet userIdsSet = Sets.newHashSet();
        AggregateUserIds aggregateUserIdsCallback = new AggregateUserIds(this.eventStorage, this.userStorage, firstStepEventIdList, eventFilters.get(0), userFilter, userIdsList, userIdsSet);
        this.shardedEventIndex.enumerateEventIds(funnelStepsEventTypes[0], startDate, endDate, aggregateUserIdsCallback);
        int[] numFunnelStepsMatched = new int[funnelStepsEventTypes.length];
        IdList.Iterator firstStepEventIdIterator = firstStepEventIdList.iterator();
        if (funnelStepsEventTypes.length == 1) {
            Iterator iterator = userIdsList.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                numFunnelStepsMatched[0] = numFunnelStepsMatched[0] + 1;
            }
        } else {
            Iterator iterator = userIdsList.iterator();
            while (iterator.hasNext()) {
                int userId = (Integer)iterator.next();
                long firstStepEventId = firstStepEventIdIterator.next();
                long maxLastStepEventId = this.datedEventIndex.findFirstEventIdOnDate(firstStepEventId, numDaysToCompleteFunnel);
                CountMatchedFunnelSteps countMatchedFunnelSteps = new CountMatchedFunnelSteps(this.eventStorage, this.userStorage, funnelStepsEventTypeIds, 1, maxLastStepEventId, eventFilters, userFilter);
                this.userEventIndex.enumerateEventIds(userId, this.userEventIndex.getEventOffset(userId, firstStepEventId), Integer.MAX_VALUE, countMatchedFunnelSteps);
                int i = 0;
                while (i < countMatchedFunnelSteps.getNumMatchedSteps()) {
                    int n = i++;
                    numFunnelStepsMatched[n] = numFunnelStepsMatched[n] + 1;
                }
            }
        }
        return numFunnelStepsMatched;
    }

    public synchronized void aliasUser(String fromExternalUserId, String toExternalUserId) {
        this.userStorage.ensureUser(toExternalUserId);
        int id = this.userStorage.getId(toExternalUserId);
        if (id == -1) {
            throw new IllegalArgumentException(String.format("User: %s does not exist!!!", toExternalUserId));
        }
        this.userStorage.alias(fromExternalUserId, id);
    }

    public synchronized int addOrUpdateUser(User user) {
        this.userStorage.ensureUser(user.getExternalId());
        int userId = this.userStorage.updateUser(user);
        this.propertiesIndex.addUser(user);
        return userId;
    }

    public User getUser(int userId) {
        return this.userStorage.getUser(userId);
    }

    public Event getEvent(long eventId) {
        return this.eventStorage.getEvent(eventId);
    }

    public synchronized long addEvent(Event event) {
        int eventTypeId = this.shardedEventIndex.ensureEventType(event.getEventType());
        int userId = this.userStorage.ensureUser(event.getExternalUserId());
        long eventId = this.eventStorage.addEvent(event, userId, eventTypeId);
        String date = event.getDate();
        this.datedEventIndex.addEvent(eventId, date);
        this.shardedEventIndex.addEvent(eventId, event.getEventType(), date);
        this.userEventIndex.addEvent(userId, eventId);
        this.propertiesIndex.addEvent(event);
        return eventId;
    }

    public List<String> getEventTypes() {
        return this.shardedEventIndex.getEventTypes();
    }

    public List<Event> getUserEvents(String externalUserId, int offset, int numRecords) {
        ArrayList events = Lists.newArrayList();
        int userId = this.userStorage.getId(externalUserId);
        this.userEventIndex.enumerateEventIds(userId, offset, numRecords, new CollectEvents(events, this.eventStorage));
        return events;
    }

    @Override
    public void close() throws IOException {
        new File(this.directory).mkdirs();
        this.eventStorage.close();
        this.userStorage.close();
        this.shardedEventIndex.close();
        this.propertiesIndex.close();
        this.datedEventIndex.close();
        this.userEventIndex.close();
    }

    public String getVarz() {
        return String.format("current date: %s\nEvent Storage:\n==============\n%s\n\nUser Storage:\n==============\n%s\n\nEvent Index:\n==============\n%s\n\nUser Event Index:\n==============\n%s", this.datedEventIndex.getCurrentDate(), this.eventStorage.getVarz(1), this.userStorage.getVarz(1), this.shardedEventIndex.getVarz(1), this.userEventIndex.getVarz(1));
    }

    private int[] getEventTypeIds(String[] eventTypes) {
        int[] eventTypeIds = new int[eventTypes.length];
        for (int i = 0; i < eventTypeIds.length; ++i) {
            eventTypeIds[i] = this.shardedEventIndex.getEventTypeId(eventTypes[i]);
        }
        return eventTypeIds;
    }

    private List<Set<Integer>> getUserIdsSets(String groupByEventType, DateTime startDate, Filter eventFilter, int numDaysPerCohort, int numCohorts) {
        ArrayList rows = Lists.newArrayListWithCapacity((int)numCohorts);
        for (int i = 0; i < numCohorts; ++i) {
            DateTime currentStartDate = startDate.plusDays(i * numDaysPerCohort);
            DateTime currentEndDate = startDate.plusDays((i + 1) * numDaysPerCohort);
            ArrayList userIdsList = Lists.newArrayList();
            HashSet userIdsSet = Sets.newHashSet();
            AggregateUserIds aggregateUserIdsCallback = new AggregateUserIds(this.eventStorage, this.userStorage, new DummyIdList(), eventFilter, TrueFilter.INSTANCE, userIdsList, userIdsSet);
            this.shardedEventIndex.enumerateEventIds(groupByEventType, currentStartDate.toString(DATE_TIME_FORMATTER), currentEndDate.toString(DATE_TIME_FORMATTER), aggregateUserIdsCallback);
            rows.add(userIdsSet);
        }
        return rows;
    }

    public List<String> getEventKeys(String eventType) {
        return this.propertiesIndex.getEventKeys(eventType);
    }

    public List<String> getEventValues(String eventType, String eventKey, String prefix) {
        return this.propertiesIndex.getEventValues(eventType, eventKey, prefix);
    }

    public List<String> getUserKeys() {
        return this.propertiesIndex.getUserKeys();
    }

    public List<String> getUserValues(String eventKey, String prefix) {
        return this.propertiesIndex.getUserValues(eventKey, prefix);
    }

    public List<User> findUsers(Filter filter) {
        ArrayList users = Lists.newArrayList();
        for (int userId = 0; userId < this.userStorage.getNumRecords(); ++userId) {
            if (!filter.accept(this.userStorage.getFilterVisitor(userId))) continue;
            users.add(this.getUser(userId));
        }
        return users;
    }

    private static class CollectEvents
    implements UserEventIndex.Callback,
    EventIndex.Callback {
        private final List<Event> events;
        private final EventStorage eventStorage;

        private CollectEvents(List<Event> events, EventStorage eventStorage) {
            this.events = events;
            this.eventStorage = eventStorage;
        }

        @Override
        public boolean shouldContinueOnEventId(long eventId) {
            this.events.add(this.eventStorage.getEvent(eventId));
            return true;
        }

        @Override
        public void onEventId(long eventId) {
            this.events.add(this.eventStorage.getEvent(eventId));
        }
    }

    private static class CountMatchedFunnelSteps
    implements UserEventIndex.Callback {
        private final EventStorage eventStorage;
        private final UserStorage userStorage;
        private final int[] funnelStepsEventTypeIds;
        private int numMatchedSteps;
        private final List<Filter> eventFilters;
        private final Filter userFilter;
        private final long maxEventId;

        public CountMatchedFunnelSteps(EventStorage eventStorage, UserStorage userStorage, int[] funnelStepsEventTypeIds, int numMatchedSteps, long maxEventId, List<Filter> eventFilters, Filter userFilter) {
            this.eventStorage = eventStorage;
            this.userStorage = userStorage;
            this.funnelStepsEventTypeIds = funnelStepsEventTypeIds;
            this.numMatchedSteps = numMatchedSteps;
            this.maxEventId = maxEventId;
            this.eventFilters = eventFilters;
            this.userFilter = userFilter;
        }

        @Override
        public boolean shouldContinueOnEventId(long eventId) {
            if (eventId >= this.maxEventId) {
                return false;
            }
            int eventTypeId = this.eventStorage.getEventTypeId(eventId);
            if (eventTypeId != this.funnelStepsEventTypeIds[this.numMatchedSteps]) {
                return true;
            }
            if (!this.eventFilters.get(this.numMatchedSteps).accept(this.eventStorage.getFilterVisitor(eventId))) {
                return true;
            }
            int userId = this.eventStorage.getUserId(eventId);
            if (!this.userFilter.accept(this.userStorage.getFilterVisitor(userId))) {
                return true;
            }
            ++this.numMatchedSteps;
            return this.numMatchedSteps != this.funnelStepsEventTypeIds.length;
        }

        public int getNumMatchedSteps() {
            return this.numMatchedSteps;
        }
    }

    private static class AggregateUserIds
    implements EventIndex.Callback {
        private final EventStorage eventStorage;
        private final UserStorage userStorage;
        private final IdList earliestEventIdList;
        private final Filter eventFilter;
        private final Filter userFilter;
        private final List<Integer> seenUserIdList;
        private final Set<Integer> seenUserIdSet;

        public AggregateUserIds(EventStorage eventStorage, UserStorage userStorage, IdList earliestEventIdList, Filter eventFilter, Filter userFilter, List<Integer> seenUserIdList, Set<Integer> seenUserIdSet) {
            this.eventStorage = eventStorage;
            this.userStorage = userStorage;
            this.earliestEventIdList = earliestEventIdList;
            this.eventFilter = eventFilter;
            this.userFilter = userFilter;
            this.seenUserIdList = seenUserIdList;
            this.seenUserIdSet = seenUserIdSet;
        }

        @Override
        public void onEventId(long eventId) {
            if (this.seenUserIdSet.contains(this.eventStorage.getUserId(eventId))) {
                return;
            }
            if (!this.eventFilter.accept(this.eventStorage.getFilterVisitor(eventId))) {
                return;
            }
            int userId = this.eventStorage.getUserId(eventId);
            if (!this.userFilter.accept(this.userStorage.getFilterVisitor(userId))) {
                return;
            }
            if (!this.seenUserIdSet.contains(userId)) {
                this.seenUserIdSet.add(userId);
                this.seenUserIdList.add(userId);
                this.earliestEventIdList.add(eventId);
            }
        }
    }
}

