/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.index.DatedEventIndex;
import com.codecademy.eventhub.index.PropertiesIndex;
import com.codecademy.eventhub.index.ShardedEventIndex;
import com.codecademy.eventhub.index.UserEventIndex;
import com.codecademy.eventhub.storage.BloomFilteredEventStorage;
import com.codecademy.eventhub.storage.BloomFilteredUserStorage;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.File;
import java.util.Properties;
import javax.inject.Named;

public class EventHubModule
extends AbstractModule {
    private final Properties properties;

    public EventHubModule(Properties properties) {
        this.properties = properties;
    }

    protected void configure() {
        Names.bindProperties((Binder)super.binder(), (Properties)this.properties);
        new File(this.properties.getProperty("eventhub.directory")).mkdirs();
    }

    @Provides
    public EventHub getEventHub(@Named(value="eventhub.directory") String directory, ShardedEventIndex shardedEventIndex, DatedEventIndex datedEventIndex, PropertiesIndex propertiesIndex, UserEventIndex userEventIndex, BloomFilteredEventStorage eventStorage, BloomFilteredUserStorage userStorage) {
        return new EventHub(directory, shardedEventIndex, datedEventIndex, propertiesIndex, userEventIndex, eventStorage, userStorage);
    }
}

