/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.base;

import com.codecademy.eventhub.base.KeyValueCallback;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

public class ByteBufferMap {
    private static final int META_DATA_SIZE_IN_BYTES = 4;
    private static final int RECORD_SIZE_IN_BYTES = 4;
    private final ByteBuffer byteBuffer;

    public ByteBufferMap(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public String get(String key) {
        ByteBuffer currentBuffer = this.byteBuffer.duplicate();
        currentBuffer.position(0);
        int numProperties = currentBuffer.getInt();
        return this.get(key, 0, numProperties, numProperties);
    }

    public void enumerate(KeyValueCallback callback) {
        ByteBuffer currentBuffer = this.byteBuffer.duplicate();
        currentBuffer.position(0);
        ByteBuffer pointersBuffer = currentBuffer.duplicate();
        pointersBuffer.position(4);
        int numProperties = currentBuffer.getInt();
        for (int i = 0; i < numProperties; ++i) {
            callback.callback(this.getKey(currentBuffer, i, numProperties), this.getValue(currentBuffer, i, numProperties));
        }
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = this.byteBuffer.duplicate();
        buffer.position(0);
        return buffer;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.enumerate(new KeyValueCallback(){

            @Override
            public void callback(String key, String value) {
                sb.append(key).append(": ").append(value).append("\n");
            }
        });
        return sb.toString();
    }

    private String get(String targetKey, int start, int end, int numProperties) {
        int currentRecordOffset;
        if (start >= end) {
            return null;
        }
        ByteBuffer currentBuffer = this.byteBuffer.duplicate();
        String key = this.getKey(currentBuffer, currentRecordOffset = start + end >>> 1, numProperties);
        int comparisonResult = key.compareTo(targetKey);
        if (comparisonResult == 0) {
            return this.getValue(currentBuffer, currentRecordOffset, numProperties);
        }
        if (comparisonResult < 0) {
            return this.get(targetKey, currentRecordOffset + 1, end, numProperties);
        }
        return this.get(targetKey, start, currentRecordOffset, numProperties);
    }

    private int calculateByteOffset(int recordOffset) {
        return 4 + recordOffset * 4;
    }

    private String getKey(ByteBuffer buffer, int recordOffset, int numProperties) {
        int startOffsetInBytes;
        buffer.position(this.calculateByteOffset(recordOffset));
        if (recordOffset == 0) {
            startOffsetInBytes = 4 + 2 * numProperties * 4;
        } else {
            buffer.position(this.calculateByteOffset(recordOffset - 1));
            startOffsetInBytes = buffer.getInt();
        }
        int finishOffsetInBytes = buffer.getInt();
        return this.getString(buffer, startOffsetInBytes, finishOffsetInBytes);
    }

    private String getValue(ByteBuffer buffer, int recordOffset, int numProperties) {
        buffer.position(this.calculateByteOffset(numProperties + recordOffset - 1));
        int startOffsetInBytes = buffer.getInt();
        buffer.position(this.calculateByteOffset(numProperties + recordOffset));
        int finishOffsetInBytes = buffer.getInt();
        return this.getString(buffer, startOffsetInBytes, finishOffsetInBytes);
    }

    private String getString(ByteBuffer buffer, int startOffsetInBytes, int finishOffsetInBytes) {
        buffer.position(startOffsetInBytes);
        byte[] keyBytes = new byte[finishOffsetInBytes - startOffsetInBytes];
        buffer.get(keyBytes);
        return new String(keyBytes);
    }

    public static ByteBufferMap build(Map<String, String> fromMap) {
        TreeMap sortedProperties = Maps.newTreeMap();
        sortedProperties.putAll(fromMap);
        int propertiesSizeInBytes = 0;
        for (Map.Entry entry : sortedProperties.entrySet()) {
            propertiesSizeInBytes += ((String)entry.getKey()).getBytes().length;
            propertiesSizeInBytes += ((String)entry.getValue()).getBytes().length;
        }
        int pointersSizeInBytes = 2 * sortedProperties.size() * 4;
        byte[] bytes = new byte[4 + pointersSizeInBytes + propertiesSizeInBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(sortedProperties.size());
        byteBuffer.position(4);
        ByteBuffer propertiesBuffer = byteBuffer.duplicate();
        propertiesBuffer.position(4 + pointersSizeInBytes);
        for (String key : sortedProperties.keySet()) {
            propertiesBuffer.put(key.getBytes());
            byteBuffer.putInt(propertiesBuffer.position());
        }
        for (String value : sortedProperties.values()) {
            propertiesBuffer.put(value.getBytes());
            byteBuffer.putInt(propertiesBuffer.position());
        }
        return new ByteBufferMap(byteBuffer);
    }
}

