/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.base;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer createNewBuffer(String filename, int fileSize) {
        try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
            MappedByteBuffer mappedByteBuffer = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            return mappedByteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MappedByteBuffer expandBuffer(String filename, MappedByteBuffer buffer, long newSize) {
        buffer.force();
        int oldPosition = buffer.position();
        try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
            raf.setLength(newSize);
            buffer = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, raf.length());
            buffer.position(oldPosition);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int binarySearchOffset(ByteBuffer buffer, int startOffset, int endOffset, long id, int recordSize) {
        if (startOffset == endOffset) {
            return endOffset;
        }
        int offset = startOffset + endOffset >>> 1;
        long value = buffer.getLong(offset * recordSize);
        if (value == id) {
            return offset;
        }
        if (value < id) {
            return ByteBufferUtil.binarySearchOffset(buffer, offset + 1, endOffset, id, recordSize);
        }
        return ByteBufferUtil.binarySearchOffset(buffer, startOffset, offset, id, recordSize);
    }
}

