/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.base;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DBIterator;

public class DB {
    private final org.iq80.leveldb.DB db;

    public DB(org.iq80.leveldb.DB db) {
        this.db = db;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> findByPrefix(String prefix, int substringStartsAt) {
        try (DBIterator iterator = this.db.iterator();){
            String key;
            ArrayList keys = Lists.newArrayList();
            iterator.seek(JniDBFactory.bytes((String)prefix));
            while (iterator.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])iterator.peekNext().getKey()))).startsWith(prefix)) {
                keys.add(key.substring(substringStartsAt));
                iterator.next();
            }
            ArrayList arrayList = keys;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void put(String key, String value) {
        this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)value));
    }

    public void put(String key, int value) {
        this.db.put(JniDBFactory.bytes((String)key), JniDBFactory.bytes((String)String.valueOf(value)));
    }

    public String get(String key) {
        byte[] bytes = this.db.get(JniDBFactory.bytes((String)key));
        return bytes == null ? null : JniDBFactory.asString((byte[])bytes);
    }

    public void close() throws IOException {
        this.db.close();
    }

    public void put(AtomicWrite atomicWrite) {
        org.iq80.leveldb.WriteBatch origWriteBatch = this.db.createWriteBatch();
        WriteBatch writeBatch = new WriteBatch(origWriteBatch);
        atomicWrite.write(writeBatch);
        this.db.write(origWriteBatch);
    }

    public static class WriteBatch {
        private final org.iq80.leveldb.WriteBatch writeBatch;

        private WriteBatch(org.iq80.leveldb.WriteBatch writeBatch) {
            this.writeBatch = writeBatch;
        }

        public void put(String key, byte[] value) {
            this.writeBatch.put(JniDBFactory.bytes((String)key), value);
        }
    }

    public static interface AtomicWrite {
        public void write(WriteBatch var1);
    }
}

