/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.base.DB;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DatedEventIndex
implements Closeable {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final String DATE_PREFIX = "d";
    private static final String ID_PREFIX = "i";
    private final DB db;
    private final List<String> dates;
    private final List<Long> earliestEventIds;
    private String currentDate;

    public DatedEventIndex(DB db, List<String> dates, List<Long> earliestEventIds, String currentDate) {
        this.db = db;
        this.dates = dates;
        this.earliestEventIds = earliestEventIds;
        this.currentDate = currentDate;
    }

    public long findFirstEventIdOnDate(long eventIdForStartDate, int numDaysAfter) {
        String dateOfEvent;
        String endDate;
        int endDateOffset;
        int startDateOffset = Collections.binarySearch(this.earliestEventIds, eventIdForStartDate);
        if (startDateOffset < 0) {
            startDateOffset = startDateOffset == -1 ? 0 : -startDateOffset - 2;
        }
        if ((endDateOffset = Collections.binarySearch(this.dates, endDate = DATE_TIME_FORMATTER.print((ReadableInstant)DateTime.parse((String)(dateOfEvent = this.dates.get(startDateOffset)), (DateTimeFormatter)DATE_TIME_FORMATTER).plusDays(numDaysAfter)))) < 0 && (endDateOffset = -endDateOffset - 1) >= this.earliestEventIds.size()) {
            return Long.MAX_VALUE;
        }
        return this.earliestEventIds.get(endDateOffset);
    }

    public synchronized void addEvent(long eventId, String date) {
        if (this.currentDate != null && date.compareTo(this.currentDate) <= 0) {
            return;
        }
        this.currentDate = date;
        this.dates.add(date);
        this.earliestEventIds.add(eventId);
        this.db.put(DATE_PREFIX + date, "");
        this.db.put(ID_PREFIX + String.format("%020d", eventId), "");
    }

    public String getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }

    public static DatedEventIndex create(DB db) {
        List<String> dates = db.findByPrefix(DATE_PREFIX, DATE_PREFIX.length());
        ArrayList earliestEventIds = Lists.newArrayList((Iterable)Lists.transform(db.findByPrefix(ID_PREFIX, ID_PREFIX.length()), (Function)new Function<String, Long>(){

            public Long apply(String s) {
                return Long.parseLong(s);
            }
        }));
        return new DatedEventIndex(db, dates, earliestEventIds, dates.isEmpty() ? "" : dates.get(dates.size() - 1));
    }
}

