/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.base.DB;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.model.User;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class PropertiesIndex
implements Closeable {
    private static final Set<String> KEYS_IGNORED = Sets.newHashSet((Object[])new String[]{"", "date", "external_user_id", "event_type"});
    private static final byte[] DUMMY = new byte[0];
    private final DB db;

    public PropertiesIndex(DB db) {
        this.db = db;
    }

    public void addEvent(final Event event) {
        final String eventType = event.getEventType();
        this.db.put(new DB.AtomicWrite(){

            @Override
            public void write(final DB.WriteBatch writeBatch) {
                event.enumerate(new KeyValueCallback(){

                    @Override
                    public void callback(String key, String value) {
                        if (KEYS_IGNORED.contains(key)) {
                            return;
                        }
                        writeBatch.put(PropertiesIndex.this.getKeyPrefixForEventType(eventType) + key, DUMMY);
                        writeBatch.put(PropertiesIndex.this.getKeyPrefixForEventTypeAndKey(eventType, key) + value, DUMMY);
                    }
                });
            }
        });
    }

    public void addUser(final User user) {
        this.db.put(new DB.AtomicWrite(){

            @Override
            public void write(final DB.WriteBatch writeBatch) {
                user.enumerate(new KeyValueCallback(){

                    @Override
                    public void callback(String key, String value) {
                        if (KEYS_IGNORED.contains(key)) {
                            return;
                        }
                        writeBatch.put(PropertiesIndex.this.getKeyPrefixForUser() + key, DUMMY);
                        writeBatch.put(PropertiesIndex.this.getKeyPrefixForUserAndKey(key) + value, DUMMY);
                    }
                });
            }
        });
    }

    public List<String> getEventKeys(String eventType) {
        String keyKey = this.getKeyPrefixForEventType(eventType);
        return this.db.findByPrefix(keyKey, keyKey.length());
    }

    public List<String> getEventValues(String eventType, String key, String valuePrefix) {
        String valueKey = this.getKeyPrefixForEventTypeAndKey(eventType, key);
        return this.db.findByPrefix(valueKey + valuePrefix, valueKey.length());
    }

    public List<String> getUserKeys() {
        String prefix = this.getKeyPrefixForUser();
        return this.db.findByPrefix(prefix, prefix.length());
    }

    public List<String> getUserValues(String key, String valuePrefix) {
        String valueKey = this.getKeyPrefixForUserAndKey(key);
        return this.db.findByPrefix(valueKey + valuePrefix, valueKey.length());
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }

    private String getKeyPrefixForUser() {
        return "__USER_KEY@@__KEY";
    }

    private String getKeyPrefixForUserAndKey(String key) {
        return Joiner.on((String)"@@").join((Object)"__USER_KEY", (Object)key, new Object[0]);
    }

    private String getKeyPrefixForEventType(String eventType) {
        return Joiner.on((String)"@@").join((Object)eventType, (Object)"__KEY", new Object[0]);
    }

    private String getKeyPrefixForEventTypeAndKey(String eventType, String key) {
        return Joiner.on((String)"@@").join((Object)eventType, (Object)key, new Object[0]);
    }
}

