/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.index.EventIndex;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ShardedEventIndex
implements Closeable {
    private final String filename;
    private final EventIndex.Factory eventIndexFactory;
    private final Map<String, EventIndex> eventIndexMap;
    private final Map<String, Integer> eventTypeIdMap;

    public ShardedEventIndex(String filename, EventIndex.Factory eventIndexFactory, Map<String, EventIndex> eventIndexMap, Map<String, Integer> eventTypeIdMap) {
        this.filename = filename;
        this.eventIndexFactory = eventIndexFactory;
        this.eventIndexMap = eventIndexMap;
        this.eventTypeIdMap = eventTypeIdMap;
    }

    public void enumerateEventIds(String eventType, String startDate, String endDate, EventIndex.Callback callback) {
        this.eventIndexMap.get(eventType).enumerateEventIds(startDate, endDate, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ensureEventType(String eventType) {
        if (this.eventTypeIdMap.containsKey(eventType)) {
            return this.eventTypeIdMap.get(eventType);
        }
        ShardedEventIndex shardedEventIndex = this;
        synchronized (shardedEventIndex) {
            int eventTypeId = this.eventIndexMap.size();
            this.eventTypeIdMap.put(eventType, eventTypeId);
            this.eventIndexMap.put(eventType, this.eventIndexFactory.build(eventType));
            this.persistEventTypeIdMap();
            return eventTypeId;
        }
    }

    public synchronized void addEvent(long eventId, String eventType, String date) {
        this.eventIndexMap.get(eventType).addEvent(eventId, date);
    }

    public List<String> getEventTypes() {
        return Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).sortedCopy(this.eventTypeIdMap.keySet());
    }

    public int getEventTypeId(String eventType) {
        return this.eventTypeIdMap.get(eventType);
    }

    @Override
    public void close() throws IOException {
        for (String eventType : this.eventIndexMap.keySet()) {
            this.eventIndexMap.get(eventType).close();
        }
        this.persistEventTypeIdMap();
    }

    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format(indent + "filename: %s", this.filename);
    }

    private void persistEventTypeIdMap() {
        new File(this.filename).getParentFile().mkdirs();
        String newFilename = this.filename + ".new";
        try {
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(newFilename));){
                oos.writeObject(this.eventTypeIdMap);
            }
            Files.move((File)new File(newFilename), (File)new File(this.filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

