/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.index.EventIndex;
import com.codecademy.eventhub.index.ShardedEventIndex;
import com.codecademy.eventhub.list.DmaIdList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.PatternFilenameFilter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;

public class ShardedEventIndexModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Named(value="eventhub.shardedeventindex.directory")
    public String getEventIndexDirectory(@Named(value="eventhub.directory") String eventHubDirectory) {
        return eventHubDirectory + "/event_index/";
    }

    @Provides
    @Named(value="eventhub.shardedeventindex.filename")
    public String getEventIndexFile(@Named(value="eventhub.shardedeventindex.directory") String eventIndexDirectory) {
        return eventIndexDirectory + "/event_index.ser";
    }

    @Provides
    @Named(value="eventhub.shardedeventindex.datedeventindex.filename")
    public String getDatedEventIndexFile(@Named(value="eventhub.shardedeventindex.directory") String eventIndexDirectory) {
        return eventIndexDirectory + "/dated_event_index.ser";
    }

    @Provides
    public EventIndex.Factory getEventIndexFactory(final @Named(value="eventhub.shardedeventindex.directory") String shardedEventIndexDirectory, @Named(value="eventhub.eventindex.initialNumEventIdsPerDay") int initialNumEventIdsPerDay, final DmaIdList.Factory dmaIdListFactory) {
        dmaIdListFactory.setDefaultCapacity(initialNumEventIdsPerDay);
        return new EventIndex.Factory(){

            @Override
            public EventIndex build(String eventType) {
                String eventIndexDirectory = String.format("%s/%s/", shardedEventIndexDirectory, eventType);
                ArrayList dates = Lists.newArrayList();
                File[] files = new File(eventIndexDirectory).listFiles((FilenameFilter)new PatternFilenameFilter("[0-9]{8}\\.ser"));
                if (files != null) {
                    for (File file : files) {
                        dates.add(file.getName().substring(0, 8));
                    }
                }
                TreeMap eventIdListMap = Maps.newTreeMap();
                for (String date : dates) {
                    eventIdListMap.put(date, dmaIdListFactory.build(EventIndex.getEventIdListFilename(eventIndexDirectory, date)));
                }
                return new EventIndex(eventIndexDirectory, dmaIdListFactory, eventIdListMap);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Provides
    public ShardedEventIndex getShardedEventIndex(@Named(value="eventhub.shardedeventindex.filename") String eventIndexFilename, EventIndex.Factory individualEventIndexFactory) {
        File file = new File(eventIndexFilename);
        if (!file.exists()) return new ShardedEventIndex(eventIndexFilename, individualEventIndexFactory, Maps.newHashMap(), Maps.newHashMap());
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            Map eventTypeIdMap = (Map)ois.readObject();
            HashMap eventIndexMap = Maps.newHashMap();
            for (String eventType : eventTypeIdMap.keySet()) {
                eventIndexMap.put(eventType, individualEventIndexFactory.build(eventType));
            }
            ShardedEventIndex shardedEventIndex = new ShardedEventIndex(eventIndexFilename, individualEventIndexFactory, eventIndexMap, eventTypeIdMap);
            return shardedEventIndex;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

