/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.base.ByteBufferUtil;
import com.codecademy.eventhub.base.Schema;
import com.codecademy.eventhub.list.DmaList;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class UserEventIndex
implements Closeable {
    public static final int POINTER_SIZE = 8;
    public static final int ID_SIZE = 8;
    private final DmaList<IndexEntry> index;
    private final IndexEntry.Factory indexEntryFactory;
    private final Block.Factory blockFactory;

    public UserEventIndex(DmaList<IndexEntry> index, IndexEntry.Factory indexEntryFactory, Block.Factory blockFactory) {
        this.index = index;
        this.indexEntryFactory = indexEntryFactory;
        this.blockFactory = blockFactory;
    }

    public int getEventOffset(int userId, long eventId) {
        IndexEntry indexEntry = this.index.get(userId);
        if (eventId <= indexEntry.getMinId()) {
            return 0;
        }
        int numPointersPerIndexEntry = this.indexEntryFactory.getNumPointers();
        int numRecordsPerBlock = this.blockFactory.getNumRecordsPerBlock();
        int numRecords = indexEntry.getNumRecords();
        int numBlocks = (int)Math.ceil((double)numRecords / (double)numRecordsPerBlock);
        long minIdInIndex = indexEntry.getMinIdInIndex(Math.min(numBlocks, numPointersPerIndexEntry) - 1);
        if (eventId >= minIdInIndex) {
            for (int i = 0; i < numBlocks; ++i) {
                if (eventId < indexEntry.getMinIdInIndex(i)) continue;
                Block block = this.blockFactory.find(indexEntry.getPointer(i));
                return block.findOffset(eventId) + block.getMetaData().getBlockOffset() * numRecordsPerBlock;
            }
        } else {
            Block block = this.blockFactory.find(this.blockFactory.find(indexEntry.getPointer(numPointersPerIndexEntry - 1)).getMetaData().getPrevBlockPointer());
            while (block != null) {
                if (eventId >= block.getMetaData().getMinId()) {
                    return block.findOffset(eventId) + block.getMetaData().getBlockOffset() * numRecordsPerBlock;
                }
                block = this.blockFactory.find(block.getMetaData().getPrevBlockPointer());
            }
        }
        throw new IllegalStateException("shouldn't even reach here!!");
    }

    public void enumerateEventIds(int userId, int recordOffset, int maxRecords, Callback callback) {
        IndexEntry indexEntry = this.index.get(userId);
        if ((maxRecords = Math.min(maxRecords, indexEntry.getNumRecords() - recordOffset)) <= 0) {
            return;
        }
        int numRecordsPerBlock = this.blockFactory.getNumRecordsPerBlock();
        int blockOffset = recordOffset / numRecordsPerBlock;
        Block block = this.findBlock(indexEntry, blockOffset);
        int offsetInCurrentBlock = recordOffset % numRecordsPerBlock;
        for (int i = 0; i < maxRecords; ++i) {
            if (offsetInCurrentBlock >= numRecordsPerBlock) {
                block = this.blockFactory.find(block.getMetaData().getNextBlockPointer());
                offsetInCurrentBlock = 0;
            }
            if (!callback.shouldContinueOnEventId(block.getRecord(offsetInCurrentBlock))) {
                return;
            }
            ++offsetInCurrentBlock;
        }
    }

    public synchronized void addEvent(int userId, long eventId) {
        IndexEntry indexEntry;
        long maxId = this.index.getMaxId();
        if ((long)userId > maxId) {
            Block block = this.blockFactory.build(0, eventId);
            indexEntry = this.indexEntryFactory.build();
            indexEntry.setMinId(eventId);
            indexEntry.shiftBlock(block);
        } else {
            indexEntry = this.index.get(userId);
            int numRecords = indexEntry.getNumRecords();
            if (numRecords == 0) {
                Block block = this.blockFactory.build(0, eventId);
                indexEntry = this.indexEntryFactory.build();
                indexEntry.setMinId(eventId);
                indexEntry.shiftBlock(block);
            } else {
                int numRecordsPerBlock = this.blockFactory.getNumRecordsPerBlock();
                int blockOffset = numRecords / numRecordsPerBlock;
                if (numRecords % numRecordsPerBlock == 0) {
                    Block block = this.blockFactory.build(blockOffset, eventId);
                    Block prevBlock = this.findBlock(indexEntry, blockOffset - 1);
                    block.getMetaData().setPrevBlockPointer(prevBlock.getMetaData().getPointer());
                    prevBlock.getMetaData().setNextBlockPointer(block.getMetaData().getPointer());
                    indexEntry.shiftBlock(block);
                } else {
                    Block block = this.findBlock(indexEntry, blockOffset);
                    block.add(eventId);
                }
            }
        }
        indexEntry.incrementNumRecord();
        this.index.update(userId, indexEntry);
    }

    @Override
    public void close() throws IOException {
        this.index.close();
        this.blockFactory.close();
    }

    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format(indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "index: %s\n", this.index.getVarz(indentation + 1));
    }

    private Block findBlock(IndexEntry indexEntry, int blockOffset) {
        int numRecordsPerBlock;
        int numPointersPerIndexEntry = this.indexEntryFactory.getNumPointers();
        int numRecords = indexEntry.getNumRecords();
        int numBlocks = (int)Math.ceil((double)numRecords / (double)(numRecordsPerBlock = this.blockFactory.getNumRecordsPerBlock()));
        if (blockOffset >= numBlocks - numPointersPerIndexEntry) {
            return this.blockFactory.find(indexEntry.getPointer(numBlocks - blockOffset - 1));
        }
        Block block = this.blockFactory.find(indexEntry.getPointer(numPointersPerIndexEntry - 1));
        for (int i = numBlocks - numPointersPerIndexEntry; i > blockOffset; --i) {
            block = this.blockFactory.find(block.getMetaData().getPrevBlockPointer());
        }
        return block;
    }

    public static interface Callback {
        public boolean shouldContinueOnEventId(long var1);
    }

    public static class IndexEntry {
        private AtomicInteger numRecords;
        private final long[] pointers;
        private final long[] minIds;
        private long minId;

        public IndexEntry(AtomicInteger numRecords, long minId, long[] pointers, long[] minIds) {
            this.numRecords = numRecords;
            this.minId = minId;
            this.pointers = pointers;
            this.minIds = minIds;
        }

        public long getPointer(int i) {
            return this.pointers[i];
        }

        public long getMinIdInIndex(int i) {
            return this.minIds[i];
        }

        public int getNumRecords() {
            return this.numRecords.get();
        }

        public void incrementNumRecord() {
            this.numRecords.incrementAndGet();
        }

        public long getMinId() {
            return this.minId;
        }

        public void setMinId(long minId) {
            this.minId = minId;
        }

        public void shiftBlock(Block block) {
            for (int i = Math.min(block.getMetaData().getBlockOffset(), this.pointers.length - 1); i > 0; --i) {
                this.pointers[i] = this.pointers[i - 1];
                this.minIds[i] = this.minIds[i - 1];
            }
            this.pointers[0] = block.getMetaData().getPointer();
            this.minIds[0] = block.getMetaData().getMinId();
        }

        public static class Factory {
            private final int numPointers;

            public Factory(int numPointers) {
                this.numPointers = numPointers;
            }

            public int getNumPointers() {
                return this.numPointers;
            }

            public IndexEntry build() {
                long[] pointers = new long[this.numPointers];
                long[] minIds = new long[this.numPointers];
                return new IndexEntry(new AtomicInteger(0), -1L, pointers, minIds);
            }
        }

        public static class Schema
        implements com.codecademy.eventhub.base.Schema<IndexEntry> {
            private final int numPointers;

            public Schema(int numPointers) {
                this.numPointers = numPointers;
            }

            @Override
            public int getObjectSize() {
                return this.numPointers * 8 + this.numPointers * 8 + 12;
            }

            @Override
            public byte[] toBytes(IndexEntry indexEntry) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.getObjectSize());
                byteBuffer.putInt(indexEntry.getNumRecords());
                byteBuffer.putLong(indexEntry.getMinId());
                for (int i = 0; i < this.numPointers; ++i) {
                    byteBuffer.putLong(indexEntry.getPointer(i));
                    byteBuffer.putLong(indexEntry.getMinIdInIndex(i));
                }
                return byteBuffer.array();
            }

            @Override
            public IndexEntry fromBytes(byte[] bytes) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                long[] pointers = new long[this.numPointers];
                long[] minIds = new long[this.numPointers];
                int numRecords = byteBuffer.getInt();
                long minId = byteBuffer.getLong();
                for (int i = 0; i < this.numPointers; ++i) {
                    pointers[i] = byteBuffer.getLong();
                    minIds[i] = byteBuffer.getLong();
                }
                return new IndexEntry(new AtomicInteger(numRecords), minId, pointers, minIds);
            }
        }
    }

    public static class Block {
        private final MetaData metaData;
        private final ByteBuffer byteBuffer;

        public Block(MetaData metaData, ByteBuffer byteBuffer) {
            this.metaData = metaData;
            this.byteBuffer = byteBuffer;
        }

        public void add(long record) {
            int recordOffset = this.metaData.getNumRecordsAndIncrement();
            this.byteBuffer.putLong(recordOffset * 8, record);
        }

        public long getRecord(int offsetInCurrentBlock) {
            return this.byteBuffer.getLong(offsetInCurrentBlock * 8);
        }

        public MetaData getMetaData() {
            return this.metaData;
        }

        public int findOffset(long id) {
            return ByteBufferUtil.binarySearchOffset(this.byteBuffer, 0, this.metaData.getNumRecords(), id, 8);
        }

        public static class Factory
        implements Closeable {
            private final String filename;
            private final int numBlocksPerFile;
            private long currentPointer;
            private final LoadingCache<Integer, MappedByteBuffer> buffers;
            private final int numRecordsPerBlock;

            public Factory(String filename, LoadingCache<Integer, MappedByteBuffer> buffers, int numRecordsPerBlock, int numBlocksPerFile, long currentPointer) {
                this.filename = filename;
                this.buffers = buffers;
                this.numRecordsPerBlock = numRecordsPerBlock;
                this.numBlocksPerFile = numBlocksPerFile;
                this.currentPointer = currentPointer;
            }

            public int getNumRecordsPerBlock() {
                return this.numRecordsPerBlock;
            }

            public Block find(long pointer) {
                int fileSize = this.numBlocksPerFile * (this.numRecordsPerBlock * 8 + 40);
                MappedByteBuffer byteBuffer = (MappedByteBuffer)this.buffers.getUnchecked((Object)((int)(pointer / (long)fileSize)));
                ByteBuffer metaDataByteBuffer = byteBuffer.duplicate();
                metaDataByteBuffer.position((int)(pointer % (long)fileSize));
                metaDataByteBuffer = metaDataByteBuffer.slice();
                ByteBuffer blockByteBuffer = byteBuffer.duplicate();
                blockByteBuffer.position((int)(pointer % (long)fileSize) + 40);
                blockByteBuffer = blockByteBuffer.slice();
                return new Block(new MetaData(metaDataByteBuffer), blockByteBuffer);
            }

            public synchronized Block build(int blockOffset, long id) {
                int fileSize = this.numBlocksPerFile * (this.numRecordsPerBlock * 8 + 40);
                long pointer = this.currentPointer;
                MappedByteBuffer byteBuffer = (MappedByteBuffer)this.buffers.getUnchecked((Object)((int)(pointer / (long)fileSize)));
                int blockSize = this.numRecordsPerBlock * 8 + 40;
                this.currentPointer += (long)blockSize;
                ByteBuffer metaDataByteBuffer = byteBuffer.duplicate();
                metaDataByteBuffer.position((int)(pointer % (long)fileSize));
                metaDataByteBuffer = metaDataByteBuffer.slice();
                ByteBuffer blockByteBuffer = byteBuffer.duplicate();
                blockByteBuffer.position((int)(pointer % (long)fileSize) + 40);
                blockByteBuffer = blockByteBuffer.slice();
                MetaData metaData = new MetaData(metaDataByteBuffer);
                metaData.setBlockOffset(blockOffset);
                metaData.setPointer(pointer);
                metaData.setMinId(id);
                Block block = new Block(metaData, blockByteBuffer);
                block.add(id);
                return block;
            }

            @Override
            public void close() throws IOException {
                new File(this.filename).getParentFile().mkdirs();
                try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));){
                    oos.writeLong(this.currentPointer);
                }
                this.buffers.invalidateAll();
            }
        }

        public static class MetaData {
            public static final int SIZE = 40;
            private final ByteBuffer byteBuffer;

            public MetaData(ByteBuffer byteBuffer) {
                this.byteBuffer = byteBuffer;
            }

            public int getBlockOffset() {
                return this.byteBuffer.getInt(0);
            }

            public void setBlockOffset(int blockOffset) {
                this.byteBuffer.putInt(0, blockOffset);
            }

            public int getNumRecords() {
                return this.byteBuffer.getInt(4);
            }

            public void setNumRecords(int numRecords) {
                this.byteBuffer.putInt(4, numRecords);
            }

            public synchronized int getNumRecordsAndIncrement() {
                int numRecords = this.getNumRecords();
                this.byteBuffer.putInt(4, numRecords + 1);
                return numRecords;
            }

            public long getPointer() {
                return this.byteBuffer.getLong(8);
            }

            public void setPointer(long pointer) {
                this.byteBuffer.putLong(8, pointer);
            }

            public long getMinId() {
                return this.byteBuffer.getLong(16);
            }

            public void setMinId(long minId) {
                this.byteBuffer.putLong(16, minId);
            }

            public long getPrevBlockPointer() {
                return this.byteBuffer.getLong(24);
            }

            public void setPrevBlockPointer(long prevBlockPointer) {
                this.byteBuffer.putLong(24, prevBlockPointer);
            }

            public long getNextBlockPointer() {
                return this.byteBuffer.getLong(32);
            }

            public void setNextBlockPointer(long nextBlockPointer) {
                this.byteBuffer.putLong(32, nextBlockPointer);
            }
        }
    }
}

