/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.index;

import com.codecademy.eventhub.base.ByteBufferUtil;
import com.codecademy.eventhub.index.UserEventIndex;
import com.codecademy.eventhub.list.DmaList;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.MappedByteBuffer;
import javax.inject.Named;

public class UserEventIndexModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Named(value="eventhub.usereventindex.directory")
    public String getUserEventIndexDirectory(@Named(value="eventhub.directory") String directory) {
        return directory + "/user_event_index/";
    }

    @Provides
    public DmaList<UserEventIndex.IndexEntry> getIndexEntryDmaList(@Named(value="eventhub.usereventindex.directory") String directory, @Named(value="eventhub.usereventindex.numPointersPerIndexEntry") int numPointers, @Named(value="eventhub.usereventindex.numIndexEntryPerFile") int numIndexEntryPerFile, @Named(value="eventhub.usereventindex.indexEntryFileCacheSize") int indexEntryFileCacheSize) {
        return DmaList.build(new UserEventIndex.IndexEntry.Schema(numPointers), directory, numIndexEntryPerFile, indexEntryFileCacheSize);
    }

    @Provides
    public UserEventIndex.IndexEntry.Factory getIndexEntryFactory(@Named(value="eventhub.usereventindex.numPointersPerIndexEntry") int numPointers) {
        return new UserEventIndex.IndexEntry.Factory(numPointers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Provides
    public UserEventIndex.Block.Factory getBlockFactory(final @Named(value="eventhub.usereventindex.directory") String directory, @Named(value="eventhub.usereventindex.blockCacheSize") int blockCacheSize, @Named(value="eventhub.usereventindex.numRecordsPerBlock") int numRecordsPerBlock, @Named(value="eventhub.usereventindex.numBlocksPerFile") int numBlocksPerFile) {
        final int fileSize = numBlocksPerFile * (numRecordsPerBlock * 8 + 40);
        LoadingCache buffers = CacheBuilder.newBuilder().maximumSize((long)blockCacheSize).recordStats().removalListener((RemovalListener)new RemovalListener<Integer, MappedByteBuffer>(){

            public void onRemoval(RemovalNotification<Integer, MappedByteBuffer> notification) {
                MappedByteBuffer value = (MappedByteBuffer)notification.getValue();
                if (value != null) {
                    value.force();
                }
            }
        }).build((CacheLoader)new CacheLoader<Integer, MappedByteBuffer>(){

            public MappedByteBuffer load(Integer key) throws Exception {
                return ByteBufferUtil.createNewBuffer(String.format("%s/block_%d.mem", directory, key), fileSize);
            }
        });
        String filename = directory + "block_factory.ser";
        File file = new File(filename);
        if (!file.exists()) return new UserEventIndex.Block.Factory(filename, (LoadingCache<Integer, MappedByteBuffer>)buffers, numRecordsPerBlock, numBlocksPerFile, 0L);
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            long currentPointer = ois.readLong();
            UserEventIndex.Block.Factory factory = new UserEventIndex.Block.Factory(filename, (LoadingCache<Integer, MappedByteBuffer>)buffers, numRecordsPerBlock, numBlocksPerFile, currentPointer);
            return factory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Provides
    public UserEventIndex getUserEventIndex(@Named(value="eventhub.usereventindex.directory") String directory, DmaList<UserEventIndex.IndexEntry> index, UserEventIndex.IndexEntry.Factory indexEntryFactory, UserEventIndex.Block.Factory blockFactory) {
        return new UserEventIndex(index, indexEntryFactory, blockFactory);
    }
}

