/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class MigrateIdMapToUseLevelDB {
    public static void main(String[] args) throws Exception {
        String userStorageDirectory = args[0];
        String filename = userStorageDirectory + "/id_map.ser";
        File file = new File(filename);
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            Map idMap = (Map)ois.readObject();
            int currentId = ois.readInt();
            Options options = new Options();
            options.createIfMissing(true);
            try (DB idMapDb = JniDBFactory.factory.open(new File(userStorageDirectory + "/id_map.db"), options);
                 WriteBatch batch = idMapDb.createWriteBatch();){
                for (Map.Entry entry : idMap.entrySet()) {
                    batch.put(JniDBFactory.bytes((String)((String)entry.getKey())), JniDBFactory.bytes((String)("" + entry.getValue())));
                }
                batch.put(JniDBFactory.bytes((String)"__eventtracker__id"), JniDBFactory.bytes((String)("" + currentId)));
                idMapDb.write(batch);
            }
        }
    }
}

