/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.list;

import com.codecademy.eventhub.base.ByteBufferUtil;
import com.codecademy.eventhub.list.IdList;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class DmaIdList
implements IdList,
Closeable {
    static final int META_DATA_SIZE = 4;
    static final int SIZE_OF_DATA = 8;
    private static final int MAX_NUM_RECORDS = 0xFFFFFFF;
    private final String filename;
    private MappedByteBuffer buffer;
    private int numRecords;
    private long capacity;

    public DmaIdList(String filename, MappedByteBuffer buffer, int numRecords, int capacity) {
        this.filename = filename;
        this.buffer = buffer;
        this.numRecords = numRecords;
        this.capacity = capacity;
    }

    @Override
    public void add(long id) {
        if (this.numRecords == 0xFFFFFFF) {
            throw new IllegalStateException(String.format("DmaIdList reaches its maximum number of records: %d", this.numRecords));
        }
        if ((long)this.numRecords == this.capacity) {
            this.buffer = ByteBufferUtil.expandBuffer(this.filename, this.buffer, 4L + Math.min(0xFFFFFFFL, 2L * this.capacity) * 8L);
            this.capacity *= 2L;
        }
        this.buffer.putLong(id);
        this.buffer.putInt(0, ++this.numRecords);
    }

    @Override
    public int getStartOffset(long eventId) {
        ByteBuffer duplicate = this.buffer.duplicate();
        duplicate.position(4);
        duplicate = duplicate.slice();
        return ByteBufferUtil.binarySearchOffset(duplicate, 0, this.numRecords, eventId, 8);
    }

    @Override
    public Iterator subList(int startOffset, int maxRecords) {
        int endOffset = startOffset + maxRecords;
        endOffset = Math.min(endOffset < 0 ? Integer.MAX_VALUE : endOffset, this.numRecords);
        return new Iterator(this.buffer, startOffset, endOffset);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(this.buffer, 0L, this.numRecords);
    }

    @Override
    public void close() {
        this.buffer.force();
        this.buffer = null;
    }

    public static class Iterator
    implements IdList.Iterator {
        private final MappedByteBuffer buffer;
        private final long start;
        private final long end;
        private long offset;

        public Iterator(MappedByteBuffer buffer, long start, long end) {
            this.buffer = buffer;
            this.start = start;
            this.end = end;
            this.offset = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.start + this.offset < this.end;
        }

        @Override
        public long next() {
            long kthRecord = this.start + this.offset++;
            return this.buffer.getLong(4 + (int)kthRecord * 8);
        }
    }

    public static interface Factory {
        public DmaIdList build(String var1);

        public void setDefaultCapacity(int var1);
    }
}

