/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.list;

import com.codecademy.eventhub.list.DmaIdList;
import com.google.inject.AbstractModule;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DmaIdListModule
extends AbstractModule {
    protected void configure() {
        this.bind(DmaIdList.Factory.class).to(DmaIdListFactory.class);
    }

    private static class DmaIdListFactory
    implements DmaIdList.Factory {
        private int defaultCapacity = 10;

        private DmaIdListFactory() {
        }

        @Override
        public void setDefaultCapacity(int defaultCapacity) {
            this.defaultCapacity = defaultCapacity;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DmaIdList build(String filename) {
            try {
                Throwable throwable;
                RandomAccessFile raf;
                File file = new File(filename);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    raf = new RandomAccessFile(new File(filename), "rw");
                    throwable = null;
                    try {
                        raf.setLength(4 + this.defaultCapacity * 8);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (raf != null) {
                            if (throwable != null) {
                                try {
                                    raf.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                raf.close();
                            }
                        }
                    }
                }
                raf = new RandomAccessFile(new File(filename), "rw");
                throwable = null;
                try {
                    FileChannel channel = raf.getChannel();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, raf.length());
                    int numRecords = buffer.getInt();
                    int capacity = (int)(raf.length() - 4L) / 8;
                    buffer.position(4 + numRecords * 8);
                    DmaIdList dmaIdList = new DmaIdList(filename, buffer, numRecords, capacity);
                    return dmaIdList;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (raf != null) {
                        if (throwable != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            raf.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

