/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.list;

import com.codecademy.eventhub.base.ByteBufferUtil;
import com.codecademy.eventhub.base.Schema;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DmaList<T>
implements Closeable {
    private final String directory;
    private final Schema<T> schema;
    private final MappedByteBuffer metaDataBuffer;
    private LoadingCache<Integer, MappedByteBuffer> buffers;
    private long maxId;
    private int numRecordsPerFile;

    public DmaList(String directory, Schema<T> schema, MappedByteBuffer metaDataBuffer, LoadingCache<Integer, MappedByteBuffer> buffers, long maxId, int numRecordsPerFile) {
        this.directory = directory;
        this.schema = schema;
        this.metaDataBuffer = metaDataBuffer;
        this.buffers = buffers;
        this.maxId = maxId;
        this.numRecordsPerFile = numRecordsPerFile;
    }

    public void add(T t) {
        int currentBufferIndex = (int)(this.maxId / (long)this.numRecordsPerFile);
        ByteBuffer duplicate = ((MappedByteBuffer)this.buffers.getUnchecked((Object)currentBufferIndex)).duplicate();
        duplicate.position((int)(this.maxId % (long)this.numRecordsPerFile) * this.schema.getObjectSize());
        duplicate.put(this.schema.toBytes(t));
        this.metaDataBuffer.putLong(0, ++this.maxId);
    }

    public void update(long id, T t) {
        if (id > this.maxId) {
            this.maxId = id;
        }
        int currentBufferIndex = (int)(id / (long)this.numRecordsPerFile);
        ByteBuffer duplicate = ((MappedByteBuffer)this.buffers.getUnchecked((Object)currentBufferIndex)).duplicate();
        duplicate.position((int)(id % (long)this.numRecordsPerFile) * this.schema.getObjectSize());
        duplicate.put(this.schema.toBytes(t));
    }

    public T get(long kthRecord) {
        int objectSize = this.schema.getObjectSize();
        byte[] bytes = new byte[objectSize];
        ByteBuffer newBuffer = ((MappedByteBuffer)this.buffers.getUnchecked((Object)((int)(kthRecord / (long)this.numRecordsPerFile)))).duplicate();
        newBuffer.position((int)(kthRecord % (long)this.numRecordsPerFile) * objectSize);
        newBuffer.get(bytes, 0, objectSize);
        return this.schema.fromBytes(bytes);
    }

    public byte[] getBytes(long kthRecord) {
        int objectSize = this.schema.getObjectSize();
        byte[] bytes = new byte[objectSize];
        ByteBuffer newBuffer = ((MappedByteBuffer)this.buffers.getUnchecked((Object)((int)(kthRecord / (long)this.numRecordsPerFile)))).duplicate();
        newBuffer.position((int)(kthRecord % (long)this.numRecordsPerFile) * objectSize);
        newBuffer.get(bytes, 0, objectSize);
        return bytes;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format(indent + "directory: %s\n" + indent + "buffer: %s", this.directory, this.buffers.stats().toString());
    }

    @Override
    public void close() {
        this.buffers.invalidateAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> DmaList<T> build(Schema<T> schema, final String directory, int numRecordsPerFile, int cacheSize) {
        new File(directory).mkdirs();
        try (RandomAccessFile raf = new RandomAccessFile(new File(String.format("%s/meta_data.mem", directory)), "rw");){
            MappedByteBuffer metaDataBuffer = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 8L);
            long numRecords = metaDataBuffer.getLong();
            final int fileSize = numRecordsPerFile * schema.getObjectSize();
            LoadingCache buffers = CacheBuilder.newBuilder().maximumSize((long)cacheSize).recordStats().removalListener((RemovalListener)new RemovalListener<Integer, MappedByteBuffer>(){

                public void onRemoval(RemovalNotification<Integer, MappedByteBuffer> notification) {
                    MappedByteBuffer value = (MappedByteBuffer)notification.getValue();
                    if (value != null) {
                        value.force();
                    }
                }
            }).build((CacheLoader)new CacheLoader<Integer, MappedByteBuffer>(){

                public MappedByteBuffer load(Integer key) throws Exception {
                    return ByteBufferUtil.createNewBuffer(String.format("%s/dma_list_%d.mem", directory, key), fileSize);
                }
            });
            DmaList<T> dmaList = new DmaList<T>(directory, schema, metaDataBuffer, (LoadingCache<Integer, MappedByteBuffer>)buffers, numRecords, numRecordsPerFile);
            return dmaList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

