/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.list;

import com.codecademy.eventhub.list.IdList;
import java.util.Arrays;

public class MemIdList
implements IdList {
    private long[] list;
    private int numRecords;

    public MemIdList(long[] list, int numRecords) {
        this.list = list;
        this.numRecords = numRecords;
    }

    @Override
    public int getStartOffset(long eventId) {
        int offset = Arrays.binarySearch(this.list, 0, this.numRecords, eventId);
        if (offset < 0) {
            offset = -offset - 1;
        }
        return offset;
    }

    @Override
    public void add(long id) {
        if (this.list.length == 0) {
            this.list = new long[1];
        }
        if (this.numRecords == this.list.length) {
            long[] newList = new long[this.list.length * 2];
            System.arraycopy(this.list, 0, newList, 0, this.list.length);
            this.list = newList;
        }
        this.list[this.numRecords++] = id;
    }

    @Override
    public Iterator subList(int start, int maxRecords) {
        int end = start + maxRecords;
        end = Math.min(end < 0 ? Integer.MAX_VALUE : end, this.numRecords);
        return new Iterator(this.list, start, end);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(this.list, 0, this.numRecords);
    }

    @Override
    public void close() {
    }

    public long[] getList() {
        return Arrays.copyOf(this.list, this.numRecords);
    }

    public static class Iterator
    implements IdList.Iterator {
        private final long[] list;
        private final int start;
        private final int end;
        private int offset;

        public Iterator(long[] list, int start, int end) {
            this.list = list;
            this.start = start;
            this.end = end;
            this.offset = 0;
        }

        @Override
        public boolean hasNext() {
            return this.start + this.offset < this.end;
        }

        @Override
        public long next() {
            return this.list[this.start + this.offset++];
        }
    }
}

