/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.model;

import com.codecademy.eventhub.base.ByteBufferMap;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class Event {
    private final ByteBufferMap byteBufferMap;

    private Event(ByteBufferMap byteBufferMap) {
        this.byteBufferMap = byteBufferMap;
    }

    public String getEventType() {
        return this.byteBufferMap.get("event_type");
    }

    public String getDate() {
        return this.byteBufferMap.get("date");
    }

    public String getExternalUserId() {
        return this.byteBufferMap.get("external_user_id");
    }

    public String get(String key) {
        return this.byteBufferMap.get(key);
    }

    public void enumerate(KeyValueCallback callback) {
        this.byteBufferMap.enumerate(callback);
    }

    public ByteBuffer toByteBuffer() {
        return this.byteBufferMap.toByteBuffer();
    }

    public static Event fromByteBuffer(ByteBuffer byteBuffer) {
        return new Event(new ByteBufferMap(byteBuffer.duplicate()));
    }

    public String toString() {
        return String.format("event type: %s\ndate: %s\nexternal user id: %s", this.getEventType(), this.getDate(), this.getExternalUserId());
    }

    public static class Builder {
        private final String eventType;
        private final String externalUserId;
        private final String date;
        private Map<String, String> properties;

        public Builder(String eventType, String externalUserId, String date, Map<String, String> properties) {
            this.eventType = eventType;
            this.externalUserId = externalUserId;
            this.date = date;
            this.properties = properties;
        }

        public Builder add(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Event build() {
            HashMap allProperties = Maps.newHashMap();
            allProperties.putAll(this.properties);
            allProperties.put("event_type", this.eventType);
            allProperties.put("date", this.date);
            allProperties.put("external_user_id", this.externalUserId);
            return new Event(ByteBufferMap.build(allProperties));
        }
    }
}

