/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.model;

import com.codecademy.eventhub.base.ByteBufferMap;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class User {
    private final ByteBufferMap byteBufferMap;

    private User(ByteBufferMap byteBufferMap) {
        this.byteBufferMap = byteBufferMap;
    }

    public String getExternalId() {
        return this.get("external_user_id");
    }

    public String get(String key) {
        return this.byteBufferMap.get(key);
    }

    public void enumerate(KeyValueCallback callback) {
        this.byteBufferMap.enumerate(callback);
    }

    public ByteBuffer toByteBuffer() {
        return this.byteBufferMap.toByteBuffer();
    }

    public String toString() {
        return String.format("external user id: %s" + this.getExternalId(), new Object[0]);
    }

    public static User fromByteBuffer(ByteBuffer byteBuffer) {
        return new User(new ByteBufferMap(byteBuffer.duplicate()));
    }

    public static class Builder {
        private final String externalId;
        private Map<String, String> properties;

        public Builder(String externalId, Map<String, String> properties) {
            this.externalId = externalId;
            this.properties = properties;
        }

        public Builder add(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public User build() {
            HashMap allProperties = Maps.newHashMap();
            allProperties.putAll(this.properties);
            allProperties.put("external_user_id", this.externalId);
            return new User(ByteBufferMap.build(allProperties));
        }
    }
}

