/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.BloomFilter;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.storage.DelegateEventStorage;
import com.codecademy.eventhub.storage.EventStorage;
import com.codecademy.eventhub.storage.filter.ExactMatch;
import com.codecademy.eventhub.storage.filter.Regex;
import com.codecademy.eventhub.storage.visitor.DelayedVisitorProxy;
import com.codecademy.eventhub.storage.visitor.Visitor;
import java.io.IOException;
import javax.inject.Provider;

public class BloomFilteredEventStorage
extends DelegateEventStorage {
    private final DmaList<BloomFilter> bloomFilterDmaList;
    private final Provider<BloomFilter> bloomFilterProvider;
    private long numConditionCheck;
    private long numBloomFilterRejection;

    public BloomFilteredEventStorage(EventStorage eventStorage, DmaList<BloomFilter> bloomFilterDmaList, Provider<BloomFilter> bloomFilterProvider) {
        super(eventStorage);
        this.bloomFilterDmaList = bloomFilterDmaList;
        this.bloomFilterProvider = bloomFilterProvider;
        this.numConditionCheck = 0L;
        this.numBloomFilterRejection = 0L;
    }

    @Override
    public long addEvent(Event event, int userId, int eventTypeId) {
        final BloomFilter bloomFilter = (BloomFilter)this.bloomFilterProvider.get();
        event.enumerate(new KeyValueCallback(){

            @Override
            public void callback(String key, String value) {
                bloomFilter.add(BloomFilteredEventStorage.getBloomFilterKey(key, value));
            }
        });
        this.bloomFilterDmaList.add(bloomFilter);
        return super.addEvent(event, userId, eventTypeId);
    }

    @Override
    public Visitor getFilterVisitor(final long eventId) {
        return new DelayedVisitorProxy(new Provider<Visitor>(){

            public Visitor get() {
                BloomFilter bloomFilter = (BloomFilter)BloomFilteredEventStorage.this.bloomFilterDmaList.get(eventId);
                Visitor visitorFromSuper = BloomFilteredEventStorage.super.getFilterVisitor(eventId);
                BloomFilteredEventStorage.this.numConditionCheck++;
                return new BloomFilteredFilterVisitor(bloomFilter, visitorFromSuper);
            }
        });
    }

    @Override
    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format("%s\n\n" + indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "num condition check: %d\n" + indent + "num bloomfilter rejection: %d", super.getVarz(indentation), this.numConditionCheck, this.numBloomFilterRejection);
    }

    @Override
    public void close() throws IOException {
        this.bloomFilterDmaList.close();
        super.close();
    }

    private static String getBloomFilterKey(String key, String value) {
        return key + value;
    }

    private class BloomFilteredFilterVisitor
    implements Visitor {
        private final BloomFilter bloomFilter;
        private final Visitor visitor;

        public BloomFilteredFilterVisitor(BloomFilter bloomFilter, Visitor visitor) {
            this.bloomFilter = bloomFilter;
            this.visitor = visitor;
        }

        @Override
        public boolean visit(ExactMatch exactMatch) {
            String bloomFilterKey = BloomFilteredEventStorage.getBloomFilterKey(exactMatch.getKey(), exactMatch.getValue());
            if (!this.bloomFilter.isPresent(bloomFilterKey)) {
                BloomFilteredEventStorage.this.numBloomFilterRejection++;
                return false;
            }
            return this.visitor.visit(exactMatch);
        }

        @Override
        public boolean visit(Regex regex) {
            return this.visitor.visit(regex);
        }
    }
}

