/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.BloomFilter;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.DelegateUserStorage;
import com.codecademy.eventhub.storage.UserStorage;
import com.codecademy.eventhub.storage.filter.ExactMatch;
import com.codecademy.eventhub.storage.filter.Regex;
import com.codecademy.eventhub.storage.visitor.DelayedVisitorProxy;
import com.codecademy.eventhub.storage.visitor.Visitor;
import com.google.common.collect.Maps;
import java.io.IOException;
import javax.inject.Provider;

public class BloomFilteredUserStorage
extends DelegateUserStorage {
    private final DmaList<BloomFilter> bloomFilterDmaList;
    private final Provider<BloomFilter> bloomFilterProvider;
    private long numConditionCheck;
    private long numBloomFilterRejection;

    public BloomFilteredUserStorage(UserStorage userStorage, DmaList<BloomFilter> bloomFilterDmaList, Provider<BloomFilter> bloomFilterProvider) {
        super(userStorage);
        this.bloomFilterDmaList = bloomFilterDmaList;
        this.bloomFilterProvider = bloomFilterProvider;
        this.numConditionCheck = 0L;
        this.numBloomFilterRejection = 0L;
    }

    @Override
    public int ensureUser(String externalUserId) {
        int id = this.getId(externalUserId);
        if (id != -1) {
            return id;
        }
        id = super.ensureUser(externalUserId);
        final BloomFilter bloomFilter = (BloomFilter)this.bloomFilterProvider.get();
        User user = new User.Builder(externalUserId, Maps.newHashMap()).build();
        user.enumerate(new KeyValueCallback(){

            @Override
            public void callback(String key, String value) {
                bloomFilter.add(BloomFilteredUserStorage.getBloomFilterKey(key, value));
            }
        });
        this.bloomFilterDmaList.add(bloomFilter);
        return id;
    }

    @Override
    public int updateUser(User user) {
        int id = this.getId(user.getExternalId());
        final BloomFilter bloomFilter = (BloomFilter)this.bloomFilterProvider.get();
        user.enumerate(new KeyValueCallback(){

            @Override
            public void callback(String key, String value) {
                bloomFilter.add(BloomFilteredUserStorage.getBloomFilterKey(key, value));
            }
        });
        this.bloomFilterDmaList.update(id, bloomFilter);
        return super.updateUser(user);
    }

    @Override
    public Visitor getFilterVisitor(final int userId) {
        return new DelayedVisitorProxy(new Provider<Visitor>(){

            public Visitor get() {
                BloomFilter bloomFilter = (BloomFilter)BloomFilteredUserStorage.this.bloomFilterDmaList.get(userId);
                Visitor visitorFromSuper = BloomFilteredUserStorage.super.getFilterVisitor(userId);
                BloomFilteredUserStorage.this.numConditionCheck++;
                return new BloomFilteredFilterVisitor(bloomFilter, visitorFromSuper);
            }
        });
    }

    @Override
    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format("%s\n\n" + indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "num condition check: %d\n" + indent + "num bloomfilter rejection: %d", super.getVarz(indentation), this.numConditionCheck, this.numBloomFilterRejection);
    }

    @Override
    public void close() throws IOException {
        this.bloomFilterDmaList.close();
        super.close();
    }

    private static String getBloomFilterKey(String key, String value) {
        return key + value;
    }

    private class BloomFilteredFilterVisitor
    implements Visitor {
        private final BloomFilter bloomFilter;
        private final Visitor visitor;

        public BloomFilteredFilterVisitor(BloomFilter bloomFilter, Visitor visitor) {
            this.bloomFilter = bloomFilter;
            this.visitor = visitor;
        }

        @Override
        public boolean visit(ExactMatch exactMatch) {
            String bloomFilterKey = BloomFilteredUserStorage.getBloomFilterKey(exactMatch.getKey(), exactMatch.getValue());
            if (!this.bloomFilter.isPresent(bloomFilterKey)) {
                BloomFilteredUserStorage.this.numBloomFilterRejection++;
                return false;
            }
            return this.visitor.visit(exactMatch);
        }

        @Override
        public boolean visit(Regex regex) {
            return this.visitor.visit(regex);
        }
    }
}

