/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.DelegateUserStorage;
import com.codecademy.eventhub.storage.UserStorage;
import com.google.common.cache.Cache;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class CachedUserStorage
extends DelegateUserStorage {
    private final Cache<Integer, User> userCache;

    public CachedUserStorage(UserStorage userStorage, Cache<Integer, User> userCache) {
        super(userStorage);
        this.userCache = userCache;
    }

    @Override
    public int updateUser(User user) {
        int userId = super.updateUser(user);
        this.userCache.invalidate((Object)userId);
        return userId;
    }

    @Override
    public User getUser(final int userId) {
        try {
            return (User)this.userCache.get((Object)userId, (Callable)new Callable<User>(){

                @Override
                public User call() {
                    return CachedUserStorage.super.getUser(userId);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format("%s\n\n" + indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "userCache: %s", super.getVarz(indentation), this.userCache.stats().toString());
    }
}

