/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.BloomFilter;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.storage.BloomFilteredEventStorage;
import com.codecademy.eventhub.storage.CachedEventStorage;
import com.codecademy.eventhub.storage.JournalEventStorage;
import com.codecademy.eventhub.storage.JournalUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.inject.Named;
import javax.inject.Provider;
import org.fusesource.hawtjournal.api.Journal;

public class EventStorageModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Named(value="eventhub.eventstorage.directory")
    public String getJournalUserStorageDirectory(@Named(value="eventhub.directory") String directory) {
        return directory + "/event_storage/";
    }

    @Provides
    public BloomFilter.Schema getBloomFilterSchema(@Named(value="eventhub.bloomfilteredeventstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfilteredeventstorage.bloomFilterSize") int bloomFilterSize) {
        return new BloomFilter.Schema(numHashes, bloomFilterSize);
    }

    @Provides
    public DmaList<JournalEventStorage.MetaData> getJournalEventStorageMetaDataList(JournalEventStorage.MetaData.Schema schema, @Named(value="eventhub.eventstorage.directory") String eventStorageDirectory, @Named(value="eventhub.journaleventstorage.numMetaDataPerFile") int numMetaDataPerFile, @Named(value="eventhub.journaleventstorage.metaDataFileCacheSize") int metaDataFileCacheSize) {
        return DmaList.build(schema, eventStorageDirectory + "/journal_event_storage_meta_data/", numMetaDataPerFile, metaDataFileCacheSize);
    }

    @Provides
    @Named(value="eventhub.journaleventstorage")
    public Journal getEventJournal(@Named(value="eventhub.eventstorage.directory") String eventStorageDirectory, @Named(value="eventhub.journaleventstorage.journalFileSize") int journalFileSize, @Named(value="eventhub.journaleventstorage.journalWriteBatchSize") int journalWriteBatchSize) {
        return JournalUtil.createJournal(eventStorageDirectory + "/event_journal/", journalFileSize, journalWriteBatchSize);
    }

    @Provides
    public JournalEventStorage getJournalEventStorage(@Named(value="eventhub.journaleventstorage") Journal eventJournal, DmaList<JournalEventStorage.MetaData> metaDataList) {
        JournalEventStorage.MetaData.Schema schema = new JournalEventStorage.MetaData.Schema();
        return new JournalEventStorage(eventJournal, schema, metaDataList, metaDataList.getMaxId());
    }

    @Provides
    public CachedEventStorage getCachedEventStorage(JournalEventStorage journalEventStorage, @Named(value="eventhub.cachedeventstorage.recordCacheSize") int recordCacheSize) {
        Cache eventCache = CacheBuilder.newBuilder().maximumSize((long)recordCacheSize).recordStats().build();
        return new CachedEventStorage(journalEventStorage, (Cache<Long, Event>)eventCache);
    }

    @Provides
    @Named(value="eventhub.bloomfilteredeventstorage")
    public DmaList<BloomFilter> getBloomFilterDmaList(@Named(value="eventhub.eventstorage.directory") String eventStorageDirectory, @Named(value="eventhub.bloomfilteredeventstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfilteredeventstorage.bloomFilterSize") int bloomFilterSize, @Named(value="eventhub.bloomfilteredeventstorage.numMetaDataPerFile") int numMetaDataPerFile, @Named(value="eventhub.bloomfilteredeventstorage.metaDataFileCacheSize") int metaDataFileCacheSize) {
        return DmaList.build(new BloomFilter.Schema(numHashes, bloomFilterSize), eventStorageDirectory + "/bloom_filtered_event_storage_meta_data/", numMetaDataPerFile, metaDataFileCacheSize);
    }

    @Provides
    @Named(value="eventhub.bloomfilteredeventstorage")
    public BloomFilter getBloomFilter(@Named(value="eventhub.bloomfilteredeventstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfilteredeventstorage.bloomFilterSize") int bloomFilterSize) {
        return BloomFilter.build(numHashes, bloomFilterSize);
    }

    @Provides
    public BloomFilteredEventStorage getBloomFilteredEventStorage(CachedEventStorage cachedEventStorage, @Named(value="eventhub.bloomfilteredeventstorage") DmaList<BloomFilter> bloomFilterDmaList, @Named(value="eventhub.bloomfilteredeventstorage") Provider<BloomFilter> bloomFilterProvider) {
        return new BloomFilteredEventStorage(cachedEventStorage, bloomFilterDmaList, bloomFilterProvider);
    }
}

