/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.Schema;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.storage.EventStorage;
import com.codecademy.eventhub.storage.JournalUtil;
import com.codecademy.eventhub.storage.visitor.DelayedVisitorProxy;
import com.codecademy.eventhub.storage.visitor.EventFilterVisitor;
import com.codecademy.eventhub.storage.visitor.Visitor;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Provider;
import org.fusesource.hawtjournal.api.Journal;
import org.fusesource.hawtjournal.api.Location;

public class JournalEventStorage
implements EventStorage {
    private final Journal eventJournal;
    private final MetaData.Schema schema;
    private final DmaList<MetaData> metaDataList;
    private long currentId;

    public JournalEventStorage(Journal eventJournal, MetaData.Schema schema, DmaList<MetaData> metaDataList, long currentId) {
        this.eventJournal = eventJournal;
        this.schema = schema;
        this.metaDataList = metaDataList;
        this.currentId = currentId;
    }

    @Override
    public long addEvent(Event event, int userId, int eventTypeId) {
        try {
            long id = this.currentId++;
            byte[] location = JournalUtil.locationToBytes(this.eventJournal.write(event.toByteBuffer(), true));
            MetaData metaData = new MetaData(userId, eventTypeId, location);
            this.metaDataList.add(metaData);
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Event getEvent(long eventId) {
        try {
            Location location = new Location();
            MetaData metaData = this.metaDataList.get(eventId);
            location.readExternal((DataInput)ByteStreams.newDataInput((byte[])metaData.getLocation()));
            return Event.fromByteBuffer(this.eventJournal.read(location));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getEventTypeId(long eventId) {
        return this.schema.getEventTypeId(this.metaDataList.getBytes(eventId));
    }

    @Override
    public Visitor getFilterVisitor(final long eventId) {
        return new DelayedVisitorProxy(new Provider<Visitor>(){

            public Visitor get() {
                Event event = JournalEventStorage.this.getEvent(eventId);
                return new EventFilterVisitor(event);
            }
        });
    }

    @Override
    public int getUserId(long eventId) {
        return this.schema.getUserId(this.metaDataList.getBytes(eventId));
    }

    @Override
    public void close() throws IOException {
        this.eventJournal.close();
        this.metaDataList.close();
    }

    @Override
    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format(indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "current id: %d\n" + indent + "metaDataList:\n%s", this.currentId, this.metaDataList.getVarz(indentation + 1));
    }

    public static class MetaData {
        private final int userId;
        private final int eventTypeId;
        private final byte[] location;

        public MetaData(int userId, int eventTypeId, byte[] location) {
            this.userId = userId;
            this.eventTypeId = eventTypeId;
            this.location = location;
        }

        public byte[] getLocation() {
            return this.location;
        }

        public static class Schema
        implements com.codecademy.eventhub.base.Schema<MetaData> {
            private static final int LOCATION_SIZE = 13;

            @Override
            public int getObjectSize() {
                return 21;
            }

            @Override
            public byte[] toBytes(MetaData metaData) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.getObjectSize());
                byteBuffer.putInt(metaData.userId).putInt(metaData.eventTypeId).put(metaData.location);
                return byteBuffer.array();
            }

            @Override
            public MetaData fromBytes(byte[] bytes) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                int userId = byteBuffer.getInt();
                int eventTypeId = byteBuffer.getInt();
                byte[] location = new byte[13];
                byteBuffer.get(location);
                return new MetaData(userId, eventTypeId, location);
            }

            public int getEventTypeId(byte[] bytes) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                return byteBuffer.getInt(4);
            }

            public int getUserId(byte[] bytes) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                return byteBuffer.getInt();
            }
        }
    }
}

