/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.Schema;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.IdMap;
import com.codecademy.eventhub.storage.JournalUtil;
import com.codecademy.eventhub.storage.UserStorage;
import com.codecademy.eventhub.storage.visitor.DelayedVisitorProxy;
import com.codecademy.eventhub.storage.visitor.UserFilterVisitor;
import com.codecademy.eventhub.storage.visitor.Visitor;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Provider;
import org.fusesource.hawtjournal.api.Journal;
import org.fusesource.hawtjournal.api.Location;

public class JournalUserStorage
implements UserStorage {
    private final Journal userJournal;
    private DmaList<MetaData> metaDataList;
    private final IdMap idMap;

    public JournalUserStorage(Journal userJournal, DmaList<MetaData> metaDataList, IdMap idMap) {
        this.userJournal = userJournal;
        this.metaDataList = metaDataList;
        this.idMap = idMap;
    }

    @Override
    public synchronized int ensureUser(String externalUserId) {
        int id = this.getId(externalUserId);
        if (id != -1) {
            return id;
        }
        User user = new User.Builder(externalUserId, Maps.newHashMap()).build();
        try {
            id = this.idMap.incrementNextAvailableId();
            byte[] location = JournalUtil.locationToBytes(this.userJournal.write(user.toByteBuffer(), true));
            MetaData metaData = new MetaData(location);
            this.metaDataList.add(metaData);
            this.idMap.put(externalUserId, id);
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNumRecords() {
        return (int)this.metaDataList.getMaxId();
    }

    @Override
    public synchronized int updateUser(User user) {
        int id = this.getId(user.getExternalId());
        try {
            byte[] location = JournalUtil.locationToBytes(this.userJournal.write(user.toByteBuffer(), true));
            MetaData metaData = new MetaData(location);
            this.metaDataList.update(id, metaData);
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getId(String externalUserId) {
        Integer id = this.idMap.get(externalUserId);
        return id == null ? -1 : id;
    }

    @Override
    public User getUser(int userId) {
        try {
            Location location = new Location();
            MetaData metaData = this.metaDataList.get(userId);
            location.readExternal((DataInput)ByteStreams.newDataInput((byte[])metaData.getLocation()));
            return User.fromByteBuffer(this.userJournal.read(location));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Visitor getFilterVisitor(final int userId) {
        return new DelayedVisitorProxy(new Provider<Visitor>(){

            public Visitor get() {
                User user = JournalUserStorage.this.getUser(userId);
                return new UserFilterVisitor(user);
            }
        });
    }

    @Override
    public void alias(String fromExternalUserId, int toUserId) {
        this.idMap.put(fromExternalUserId, toUserId);
    }

    @Override
    public void close() throws IOException {
        this.idMap.close();
        this.userJournal.close();
        this.metaDataList.close();
    }

    @Override
    public String getVarz(int indentation) {
        String indent = new String(new char[indentation]).replace('\u0000', ' ');
        return String.format(indent + this.getClass().getName() + "\n" + indent + "==================\n" + indent + "current id: %d\n" + indent + "metaDataList:\n%s", this.idMap.getCurrentId(), this.metaDataList.getVarz(indentation + 1));
    }

    public static class MetaData {
        private final byte[] location;

        public MetaData(byte[] location) {
            this.location = location;
        }

        public byte[] getLocation() {
            return this.location;
        }

        public static class Schema
        implements com.codecademy.eventhub.base.Schema<MetaData> {
            private static final int LOCATION_SIZE = 13;

            @Override
            public int getObjectSize() {
                return 21;
            }

            @Override
            public byte[] toBytes(MetaData metaData) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.getObjectSize());
                byteBuffer.put(metaData.location);
                return byteBuffer.array();
            }

            @Override
            public MetaData fromBytes(byte[] bytes) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                byte[] location = new byte[13];
                byteBuffer.get(location);
                return new MetaData(location);
            }
        }
    }
}

