/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage;

import com.codecademy.eventhub.base.BloomFilter;
import com.codecademy.eventhub.base.DB;
import com.codecademy.eventhub.list.DmaList;
import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.BloomFilteredUserStorage;
import com.codecademy.eventhub.storage.CachedUserStorage;
import com.codecademy.eventhub.storage.IdMap;
import com.codecademy.eventhub.storage.JournalUserStorage;
import com.codecademy.eventhub.storage.JournalUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Provider;
import org.fusesource.hawtjournal.api.Journal;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.Options;

public class UserStorageModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Named(value="eventhub.userstorage.directory")
    public String getJournalUserStorageDirectory(@Named(value="eventhub.directory") String directory) {
        return directory + "/user_storage/";
    }

    @Provides
    public DmaList<JournalUserStorage.MetaData> getJournalUserStorageMetaDataList(JournalUserStorage.MetaData.Schema schema, @Named(value="eventhub.userstorage.directory") String userStorageDirectory, @Named(value="eventhub.journaluserstorage.numMetaDataPerFile") int numMetaDataPerFile, @Named(value="eventhub.journaluserstorage.metaDataFileCacheSize") int metaDataFileCacheSize) {
        return DmaList.build(schema, userStorageDirectory + "/meta_data/", numMetaDataPerFile, metaDataFileCacheSize);
    }

    @Provides
    @Named(value="eventhub.journaluserstorage")
    public Journal getUserJournal(@Named(value="eventhub.userstorage.directory") String userStorageDirectory, @Named(value="eventhub.journaluserstorage.journalFileSize") int journalFileSize, @Named(value="eventhub.journaluserstorage.journalWriteBatchSize") int journalWriteBatchSize) {
        return JournalUtil.createJournal(userStorageDirectory + "/user_journal/", journalFileSize, journalWriteBatchSize);
    }

    @Provides
    public IdMap getIdMap(@Named(value="eventhub.userstorage.directory") String userStorageDirectory) throws IOException {
        String filename = userStorageDirectory + "/id_map.db";
        new File(userStorageDirectory).mkdirs();
        Options options = new Options();
        options.createIfMissing(true);
        return IdMap.create(new DB(JniDBFactory.factory.open(new File(filename), options)));
    }

    @Provides
    public JournalUserStorage getJournalUserStorage(@Named(value="eventhub.journaluserstorage") Journal userJournal, DmaList<JournalUserStorage.MetaData> metaDataList, IdMap idMap) {
        return new JournalUserStorage(userJournal, metaDataList, idMap);
    }

    @Provides
    public CachedUserStorage getCachedEventStorage(JournalUserStorage journalUserStorage, @Named(value="eventhub.cacheduserstorage.recordCacheSize") int recordCacheSize) {
        Cache userCache = CacheBuilder.newBuilder().maximumSize((long)recordCacheSize).recordStats().build();
        return new CachedUserStorage(journalUserStorage, (Cache<Integer, User>)userCache);
    }

    @Provides
    @Named(value="eventhub.bloomfiltereduserstorage")
    public DmaList<BloomFilter> getBloomFilterDmaList(@Named(value="eventhub.userstorage.directory") String userStorageDirectory, @Named(value="eventhub.bloomfiltereduserstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfiltereduserstorage.bloomFilterSize") int bloomFilterSize, @Named(value="eventhub.bloomfiltereduserstorage.numMetaDataPerFile") int numMetaDataPerFile, @Named(value="eventhub.bloomfiltereduserstorage.metaDataFileCacheSize") int metaDataFileCacheSize) {
        return DmaList.build(new BloomFilter.Schema(numHashes, bloomFilterSize), userStorageDirectory + "/bloom_filtered_user_storage_meta_data/", numMetaDataPerFile, metaDataFileCacheSize);
    }

    @Provides
    @Named(value="eventhub.bloomfiltereduserstorage")
    public BloomFilter getBloomFilter(@Named(value="eventhub.bloomfiltereduserstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfiltereduserstorage.bloomFilterSize") int bloomFilterSize) {
        return BloomFilter.build(numHashes, bloomFilterSize);
    }

    @Provides
    public BloomFilteredUserStorage getBloomFilteredUserStorage(@Named(value="eventhub.bloomfiltereduserstorage.numHashes") int numHashes, @Named(value="eventhub.bloomfiltereduserstorage.bloomFilterSize") int bloomFilterSize, @Named(value="eventhub.bloomfiltereduserstorage") DmaList<BloomFilter> bloomFilterDmaList, @Named(value="eventhub.bloomfiltereduserstorage") Provider<BloomFilter> bloomFilterProvider, CachedUserStorage cachedUserStorage) {
        return new BloomFilteredUserStorage(cachedUserStorage, bloomFilterDmaList, bloomFilterProvider);
    }
}

