/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.storage.visitor;

import com.codecademy.eventhub.storage.filter.ExactMatch;
import com.codecademy.eventhub.storage.filter.Regex;
import com.codecademy.eventhub.storage.visitor.Visitor;
import javax.inject.Provider;

public class DelayedVisitorProxy
implements Visitor {
    private final Provider<Visitor> visitorProvider;
    private Visitor cachedVisitor;

    public DelayedVisitorProxy(Provider<Visitor> visitorProvider) {
        this.visitorProvider = visitorProvider;
    }

    @Override
    public boolean visit(ExactMatch exactMatch) {
        if (this.cachedVisitor == null) {
            this.cachedVisitor = (Visitor)this.visitorProvider.get();
        }
        return this.cachedVisitor.visit(exactMatch);
    }

    @Override
    public boolean visit(Regex regex) {
        if (this.cachedVisitor == null) {
            this.cachedVisitor = (Visitor)this.visitorProvider.get();
        }
        return this.cachedVisitor.visit(regex);
    }
}

