/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.EventHubModule;
import com.codecademy.eventhub.index.DatedEventIndexModule;
import com.codecademy.eventhub.index.PropertiesIndexModule;
import com.codecademy.eventhub.index.ShardedEventIndexModule;
import com.codecademy.eventhub.index.UserEventIndexModule;
import com.codecademy.eventhub.list.DmaIdListModule;
import com.codecademy.eventhub.storage.EventStorageModule;
import com.codecademy.eventhub.storage.UserStorageModule;
import com.codecademy.eventhub.web.JsonpCallbackHandler;
import com.codecademy.eventhub.web.Module;
import com.codecademy.eventhub.web.commands.Command;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Provider;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

public class EventHubHandler
extends AbstractHandler
implements Closeable {
    private final EventHub eventHub;
    private final Map<String, Provider<Command>> commandsMap;
    private boolean isLogging;

    public EventHubHandler(EventHub eventHub, Map<String, Provider<Command>> commandsMaps) {
        this.eventHub = eventHub;
        this.commandsMap = commandsMaps;
        this.isLogging = false;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isLogging) {
            System.out.println(request);
        }
        response.setStatus(200);
        switch (target) {
            case "/debug": {
                this.isLogging = !this.isLogging;
                baseRequest.setHandled(true);
                break;
            }
            case "/varz": {
                response.getWriter().println(this.eventHub.getVarz());
                baseRequest.setHandled(true);
                break;
            }
            default: {
                Provider<Command> commandProvider = this.commandsMap.get(target);
                if (commandProvider == null) break;
                ((Command)commandProvider.get()).execute(request, response);
                baseRequest.setHandled(true);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.eventHub.close();
    }

    public static void main(String[] args) throws Exception {
        Properties properties = new Properties();
        properties.load(EventHub.class.getClassLoader().getResourceAsStream("hub.properties"));
        properties.load(EventHubHandler.class.getClassLoader().getResourceAsStream("web.properties"));
        properties.putAll((Map<?, ?>)System.getProperties());
        Injector injector = Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{Modules.override((com.google.inject.Module[])new com.google.inject.Module[]{new DmaIdListModule(), new DatedEventIndexModule(), new ShardedEventIndexModule(), new PropertiesIndexModule(), new UserEventIndexModule(), new EventStorageModule(), new UserStorageModule(), new EventHubModule(properties)}).with(new com.google.inject.Module[]{new Module()})});
        final EventHubHandler eventHubHandler = (EventHubHandler)injector.getInstance(EventHubHandler.class);
        int port = (Integer)injector.getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"eventhubhandler.port")));
        final Server server = new Server(port);
        String webDir = EventHubHandler.class.getClassLoader().getResource("frontend").toExternalForm();
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(properties.getProperty("eventhubhandler.username"), (Credential)new Password(properties.getProperty("eventhubhandler.password")), new String[]{"user"});
        server.addBean((Object)loginService);
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"user", "admin"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        securityHandler.setConstraintMappings(Collections.singletonList(mapping));
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)loginService);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setWelcomeFiles(new String[]{"main.html"});
        resourceHandler.setResourceBase(webDir);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{new JsonpCallbackHandler((Handler)eventHubHandler), securityHandler});
        server.setHandler((Handler)handlers);
        securityHandler.setHandler((Handler)resourceHandler);
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (server.isStarted()) {
                    try {
                        server.stop();
                        eventHubHandler.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "Stop Jetty Hook"));
        server.join();
    }
}

