/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JsonpCallbackHandler
extends AbstractHandler {
    private final Handler handler;

    public JsonpCallbackHandler(Handler handler) {
        this.handler = handler;
    }

    public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Map params = httpServletRequest.getParameterMap();
        if (params.containsKey("callback")) {
            ServletOutputStream out = httpServletResponse.getOutputStream();
            GenericResponseWrapper wrapper = new GenericResponseWrapper(httpServletResponse);
            try {
                this.handler.handle(s, request, httpServletRequest, (HttpServletResponse)wrapper);
                if (httpServletResponse.getStatus() >= 400) {
                    out.write((((String[])params.get("callback"))[0] + "({error: 'error'});").getBytes());
                } else {
                    out.write((((String[])params.get("callback"))[0] + "(").getBytes());
                    out.write(wrapper.getData());
                    out.write(");".getBytes());
                }
                wrapper.setContentType("text/javascript;charset=UTF-8");
                out.close();
            }
            catch (Exception e) {
                out.write((((String[])params.get("callback"))[0] + "({error: 'error'});").getBytes());
                wrapper.setContentType("text/javascript;charset=UTF-8");
                out.close();
                throw e;
            }
        } else {
            this.handler.handle(s, request, httpServletRequest, httpServletResponse);
        }
    }

    private static class GenericResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public GenericResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new FilterServletOutputStream(this.output);
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }
    }

    private static class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

