/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.base.KeyValueCallback;
import com.codecademy.eventhub.index.DatedEventIndex;
import com.codecademy.eventhub.index.PropertiesIndex;
import com.codecademy.eventhub.index.ShardedEventIndex;
import com.codecademy.eventhub.index.UserEventIndex;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.model.User;
import com.codecademy.eventhub.storage.BloomFilteredEventStorage;
import com.codecademy.eventhub.storage.BloomFilteredUserStorage;
import com.codecademy.eventhub.storage.EventStorage;
import com.codecademy.eventhub.storage.UserStorage;
import com.codecademy.eventhub.web.EventHubHandler;
import com.codecademy.eventhub.web.commands.Command;
import com.codecademy.eventhub.web.commands.Path;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Named;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Module
extends AbstractModule {
    private static final String PACKAGE_NAME = "com.codecademy.eventhub.web.commands";

    protected void configure() {
    }

    @Provides
    private Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(User.class, (Object)new UserJsonSerializer());
        gsonBuilder.registerTypeAdapter(Event.class, (Object)new EventJsonSerializer());
        return gsonBuilder.create();
    }

    @Provides
    @Singleton
    public EventHub getEventHub(@Named(value="eventhub.directory") String directory, ShardedEventIndex shardedEventIndex, DatedEventIndex datedEventIndex, PropertiesIndex propertiesIndex, UserEventIndex userEventIndex, BloomFilteredEventStorage eventStorage, BloomFilteredUserStorage userStorage) {
        return new EventHub(directory, shardedEventIndex, datedEventIndex, propertiesIndex, userEventIndex, (EventStorage)eventStorage, (UserStorage)userStorage);
    }

    @Provides
    private EventHubHandler getEventHubHandler(Injector injector, EventHub eventHub) throws ClassNotFoundException {
        HashMap commandsMap = Maps.newHashMap();
        Reflections reflections = new Reflections(PACKAGE_NAME, new Scanner[0]);
        Set commandClasses = reflections.getSubTypesOf(Command.class);
        for (Class commandClass : commandClasses) {
            String path = commandClass.getAnnotation(Path.class).value();
            commandsMap.put(path, injector.getProvider(commandClass));
        }
        return new EventHubHandler(eventHub, commandsMap);
    }

    private static class EventJsonSerializer
    implements JsonSerializer<Event> {
        private EventJsonSerializer() {
        }

        public JsonElement serialize(Event event, Type type, JsonSerializationContext jsonSerializationContext) {
            final JsonObject jsonObject = new JsonObject();
            event.enumerate(new KeyValueCallback(){

                public void callback(String key, String value) {
                    jsonObject.addProperty(key, value);
                }
            });
            return jsonObject;
        }
    }

    private static class UserJsonSerializer
    implements JsonSerializer<User> {
        private UserJsonSerializer() {
        }

        public JsonElement serialize(User user, Type type, JsonSerializationContext jsonSerializationContext) {
            final JsonObject jsonObject = new JsonObject();
            user.enumerate(new KeyValueCallback(){

                public void callback(String key, String value) {
                    jsonObject.addProperty(key, value);
                }
            });
            return jsonObject;
        }
    }
}

