/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web.commands;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.base.DateHelper;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.web.commands.Command;
import com.codecademy.eventhub.web.commands.Path;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Path(value="/events/batch_track")
public class BatchTrackEvent
extends Command {
    private final Gson gson;
    private final DateHelper dateHelper;
    private final EventHub eventHub;

    @Inject
    public BatchTrackEvent(Gson gson, DateHelper dateHelper, EventHub eventHub) {
        this.gson = gson;
        this.dateHelper = dateHelper;
        this.eventHub = eventHub;
    }

    @Override
    public synchronized void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List events = (List)this.gson.fromJson(request.getParameter("events"), new TypeToken<List<Map<String, String>>>(){}.getType());
        ArrayList eventIds = Lists.newArrayList();
        PrintWriter writer = response.getWriter();
        for (Map eventMap : events) {
            String date = (String)eventMap.get("date");
            if (date == null) {
                date = this.dateHelper.getDate();
            }
            Event event = new Event.Builder((String)eventMap.get("event_type"), (String)eventMap.get("external_user_id"), date, eventMap).build();
            eventIds.add(this.eventHub.addEvent(event));
        }
        writer.println(this.gson.toJson((Object)eventIds));
    }
}

