/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web.commands;

import com.codecademy.eventhub.storage.filter.And;
import com.codecademy.eventhub.storage.filter.ExactMatch;
import com.codecademy.eventhub.storage.filter.Filter;
import com.codecademy.eventhub.storage.filter.TrueFilter;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Command {
    public abstract void execute(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected Map<String, String> toProperties(final HttpServletRequest request) {
        return Maps.asMap(request.getParameterMap().keySet(), (Function)new Function<String, String>(){

            public String apply(String parameterName) {
                return request.getParameter(parameterName);
            }
        });
    }

    protected String[] merge(String[] x, String[] y) {
        if (x == null & y == null) {
            return null;
        }
        if (x == null) {
            return (String[])y.clone();
        }
        if (y == null) {
            return (String[])x.clone();
        }
        String[] ret = new String[x.length + y.length];
        System.arraycopy(x, 0, ret, 0, x.length);
        System.arraycopy(y, 0, ret, x.length, y.length);
        return ret;
    }

    protected Filter getFilter(String[] filterKeys, String[] filterValues) {
        if (filterKeys == null || filterValues == null) {
            return TrueFilter.INSTANCE;
        }
        ArrayList eventFilters = Lists.newArrayList();
        for (int i = 0; i < filterKeys.length; ++i) {
            eventFilters.add(new ExactMatch(filterKeys[i], filterValues[i]));
        }
        return new And((List)eventFilters);
    }
}

