/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web.commands;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.storage.filter.Filter;
import com.codecademy.eventhub.web.commands.Command;
import com.codecademy.eventhub.web.commands.Path;
import com.google.gson.Gson;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Path(value="/events/cohort")
public class EventCohort
extends Command {
    private final Gson gson;
    private final EventHub eventHub;

    @Inject
    public EventCohort(Gson gson, EventHub eventHub) {
        this.gson = gson;
        this.eventHub = eventHub;
    }

    @Override
    public synchronized void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Filter rowEventFilter = this.getFilter(request.getParameterValues("refk[]"), request.getParameterValues("refv[]"));
        Filter columnEventFilter = this.getFilter(request.getParameterValues("cefk[]"), request.getParameterValues("cefv[]"));
        int[][] retentionTable = this.eventHub.getRetentionTable(request.getParameter("start_date"), request.getParameter("end_date"), Integer.parseInt(request.getParameter("num_days_per_row")), Integer.parseInt(request.getParameter("num_columns")), request.getParameter("row_event_type"), request.getParameter("column_event_type"), rowEventFilter, columnEventFilter);
        response.getWriter().println(this.gson.toJson((Object)retentionTable));
    }
}

