/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web.commands;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.storage.filter.Filter;
import com.codecademy.eventhub.web.commands.Command;
import com.codecademy.eventhub.web.commands.Path;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Path(value="/events/funnel")
public class EventFunnel
extends Command {
    private final Gson gson;
    private final EventHub eventHub;

    @Inject
    public EventFunnel(Gson gson, EventHub eventHub) {
        this.gson = gson;
        this.eventHub = eventHub;
    }

    @Override
    public synchronized void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] funnelSteps = request.getParameterValues("funnel_steps[]");
        ArrayList eventFilters = Lists.newArrayList();
        for (int i = 0; i < funnelSteps.length; ++i) {
            Filter filter = this.getFilter(this.merge(request.getParameterValues("efk[]"), request.getParameterValues("efk" + i + "[]")), this.merge(request.getParameterValues("efk[]"), request.getParameterValues("efv" + i + "[]")));
            eventFilters.add(filter);
        }
        Filter userFilter = this.getFilter(request.getParameterValues("ufk[]"), request.getParameterValues("ufv[]"));
        int[] funnelCounts = this.eventHub.getFunnelCounts(request.getParameter("start_date"), request.getParameter("end_date"), funnelSteps, Integer.parseInt(request.getParameter("num_days_to_complete_funnel")), (List)eventFilters, userFilter);
        response.getWriter().println(this.gson.toJson((Object)funnelCounts));
    }
}

