/*
 * Decompiled with CFR 0.152.
 */
package com.codecademy.eventhub.web.commands;

import com.codecademy.eventhub.EventHub;
import com.codecademy.eventhub.base.DateHelper;
import com.codecademy.eventhub.model.Event;
import com.codecademy.eventhub.web.commands.Command;
import com.codecademy.eventhub.web.commands.Path;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Path(value="/events/track")
public class TrackEvent
extends Command {
    private final DateHelper dateHelper;
    private final EventHub eventHub;

    @Inject
    public TrackEvent(DateHelper dateHelper, EventHub eventHub) {
        this.dateHelper = dateHelper;
        this.eventHub = eventHub;
    }

    @Override
    public synchronized void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String date = request.getParameter("date");
        if (date == null) {
            date = this.dateHelper.getDate();
        }
        Event event = new Event.Builder(request.getParameter("event_type"), request.getParameter("external_user_id"), date, this.toProperties(request)).build();
        response.getWriter().println(this.eventHub.addEvent(event));
    }
}

