/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.aop;

import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.base.db.IncludeDeleted;
import io.featureprobe.api.base.tenant.TenantContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0)
public class TenantServiceAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceAspect.class);

    @Before(value="execution(* com.featureprobe.api.service..*.*(..)) || execution(* io.featureprobe.api.service..*.*(..))")
    public void beforeExecution(JoinPoint pjp) throws Throwable {
        Field[] fields;
        Class<?> clazz = pjp.getTarget().getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Archived archivedAnnotation;
            IncludeDeleted includeDeletedAnnotation;
            if (!StringUtils.equals((CharSequence)"entityManager", (CharSequence)field.getName())) continue;
            field.setAccessible(true);
            EntityManager entityManager = (EntityManager)field.get(pjp.getTarget());
            Session session = (Session)entityManager.unwrap(Session.class);
            ExcludeTenant excludeTenantAnnotation = clazz.getAnnotation(ExcludeTenant.class);
            ExcludeTenant excludeTenantMethodAnnotation = this.getMethodAnnotation(pjp, ExcludeTenant.class);
            if (Objects.isNull(excludeTenantAnnotation) && Objects.isNull(excludeTenantMethodAnnotation)) {
                session.enableFilter("tenantFilter").setParameter("organizationId", (Object)Long.parseLong(TenantContext.getCurrentTenant())).validate();
            }
            if (Objects.isNull(includeDeletedAnnotation = this.getMethodAnnotation(pjp, IncludeDeleted.class))) {
                session.enableFilter("deletedFilter").setParameter("deleted", (Object)false).validate();
            }
            if (Objects.isNull(archivedAnnotation = this.getMethodAnnotation(pjp, Archived.class))) {
                session.enableFilter("archivedFilter").setParameter("archived", (Object)false).validate();
                continue;
            }
            if (!Objects.nonNull(session.getEnabledFilter("archivedFilter"))) continue;
            session.disableFilter("archivedFilter");
        }
    }

    @After(value="execution(* com.featureprobe.api.service..*.*(..)) || execution(* io.featureprobe.api.service..*.*(..))")
    public void afterExecution(JoinPoint pjp) throws Throwable {
        Field[] fields;
        Class<?> clazz = pjp.getTarget().getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)"entityManager", (CharSequence)field.getName())) continue;
            field.setAccessible(true);
            EntityManager entityManager = (EntityManager)field.get(pjp.getTarget());
            Session session = (Session)entityManager.unwrap(Session.class);
            session.disableFilter("tenantFilter");
            session.disableFilter("deletedFilter");
            session.disableFilter("archivedFilter");
        }
    }

    private <T extends Annotation> T getMethodAnnotation(JoinPoint joinPoint, Class<T> clazz) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        return method.getAnnotation(clazz);
    }
}

