/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.aop;

import io.featureprobe.api.base.constants.ResponseCode;
import io.featureprobe.api.base.exception.ForbiddenException;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.component.I18nConverter;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.exception.ResourceOverflowException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.persistence.OptimisticLockException;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class WebExceptionAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebExceptionAspect.class);
    I18nConverter i18nConverter;

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void resourceNotFoundHandler(HttpServletResponse response, ResourceNotFoundException e) throws IOException {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String resourceNameMessage = this.i18nConverter.getResourceNameMessage(e.resourceType);
        String resourceNotFoundMessage = this.i18nConverter.get(ResponseCode.NOT_FOUND.messageKey(), new Object[]{resourceNameMessage, e.resourceKey});
        response.getWriter().write(this.toErrorResponse(ResponseCode.NOT_FOUND, resourceNotFoundMessage));
    }

    @ExceptionHandler(value={ResourceOverflowException.class})
    public void resourceOverflowHandler(HttpServletResponse response, ResourceOverflowException e) throws IOException {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String resourceNameMessage = this.i18nConverter.getResourceNameMessage(e.resourceType);
        String resourceOverflowMessage = this.i18nConverter.get(ResponseCode.NOT_FOUND.messageKey(), new Object[]{resourceNameMessage});
        response.getWriter().write(this.toErrorResponse(ResponseCode.OVERFLOW, resourceOverflowMessage));
    }

    @ExceptionHandler(value={ResourceConflictException.class})
    public void resourceConflictHandler(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().write(this.toErrorResponse(ResponseCode.CONFLICT));
    }

    @ExceptionHandler(value={ForbiddenException.class})
    public void forbiddenHandler(HttpServletResponse response, ForbiddenException e) throws IOException {
        response.setStatus(HttpStatus.FORBIDDEN.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().write(this.toErrorResponse(ResponseCode.FORBIDDEN));
    }

    @ExceptionHandler(value={IllegalArgumentException.class, OptimisticLockException.class})
    public void invalidArgumentHandler(HttpServletResponse response, RuntimeException e) throws IOException {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String messageKey = e.getMessage();
        if (e instanceof OptimisticLockException) {
            messageKey = "validate.conflict_request";
        }
        response.getWriter().write(this.toErrorResponse(ResponseCode.INVALID_REQUEST, this.i18nConverter.get(messageKey)));
        log.warn("invalidArgumentHandler", (Throwable)e);
    }

    private String toErrorResponse(ResponseCode resourceCode) {
        return this.toErrorResponse(resourceCode, this.i18nConverter.get(resourceCode.messageKey()));
    }

    private String toErrorResponse(ResponseCode responseCode, String message) {
        return JsonMapper.toJSONString((Object)new BaseResponse(responseCode.code(), message));
    }

    @Generated
    public WebExceptionAspect(I18nConverter i18nConverter) {
        this.i18nConverter = i18nConverter;
    }
}

