/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccessTokenAuthenticationToken;
import io.featureprobe.api.auth.AuthenticatedMember;
import io.featureprobe.api.base.enums.OperationType;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.dao.entity.AccessToken;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.OperationLog;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.service.AccessTokenService;
import io.featureprobe.api.service.MemberService;
import io.featureprobe.api.service.OperationLogService;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AccessTokenAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessTokenAuthenticationProvider.class);
    private MemberService memberService;
    private AccessTokenService accessTokenService;
    private OperationLogService operationLogService;

    @Transactional(rollbackFor={Exception.class})
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AccessTokenAuthenticationToken tokenAuth = (AccessTokenAuthenticationToken)authentication;
        Optional<AccessToken> accessToken = this.accessTokenService.findByToken(tokenAuth.getToken());
        if (!accessToken.isPresent()) {
            log.warn("API Access token not exists, token: {}", (Object)tokenAuth.getToken());
            return null;
        }
        AccessToken token = accessToken.get();
        Optional<Member> member = this.memberService.findById(token.getMemberId());
        if (!member.isPresent()) {
            log.warn("API Access token member not exists, userid: {}", (Object)token.getMemberId());
            return null;
        }
        OperationLog log = new OperationLog(OperationType.LOGIN.name() + "_AccessToken", token.getName());
        if (member.isPresent()) {
            TenantContext.setCurrentTenant((String)token.getOrganizationId().toString());
            this.memberService.updateLoginTime(member.get(), token.getOrganizationId());
            this.accessTokenService.updateVisitedTime(token.getId());
            this.operationLogService.save(log);
            return new AccessTokenAuthenticationToken(AuthenticatedMember.create(member.get(), null), String.valueOf(token.getOrganizationId()), Collections.emptyList());
        }
        return null;
    }

    private OrganizationMemberModel getDefaultOrganizationMember(Member member) {
        OrganizationMember organizationMember = (OrganizationMember)member.getOrganizationMembers().get(0);
        return new OrganizationMemberModel(organizationMember.getOrganization().getId(), organizationMember.getOrganization().getName(), organizationMember.getRole());
    }

    public boolean supports(Class<?> authentication) {
        return AccessTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @Generated
    public AccessTokenAuthenticationProvider(MemberService memberService, AccessTokenService accessTokenService, OperationLogService operationLogService) {
        this.memberService = memberService;
        this.accessTokenService = accessTokenService;
        this.operationLogService = operationLogService;
    }
}

