/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.featureprobe.api.auth.GuestAuthenticationToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class GuestAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuestAuthenticationProcessingFilter.class);
    private static final String GUEST_LOGIN_PATH = "/api/guestLogin";
    private static final String GUEST_LOGIN_ACCOUNT_PARAM = "account";
    private static final String ACCOUNT_SOURCE = "source";

    protected GuestAuthenticationProcessingFilter() {
        super(GUEST_LOGIN_PATH);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ServletInputStream is = request.getInputStream();
        String body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        Map authParam = (Map)mapper.readValue(body, Map.class);
        String account = (String)authParam.get(GUEST_LOGIN_ACCOUNT_PARAM);
        String source = (String)authParam.get(ACCOUNT_SOURCE);
        return this.getAuthenticationManager().authenticate((Authentication)new GuestAuthenticationToken(account, source, ""));
    }
}

