/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration
public class JwtConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtConfiguration.class);
    @Value(value="${app.security.jwt.keystore-location}")
    private String keyStorePath;
    @Value(value="${app.security.jwt.keystore-password}")
    private String keyStorePassword;
    @Value(value="${app.security.jwt.key-alias}")
    private String keyAlias;
    @Value(value="${app.security.jwt.private-key-passphrase}")
    private String privateKeyPassphrase;
    private RSAPrivateKey rsaPrivateKey;
    private RSAPublicKey rsaPublicKey;

    @PostConstruct
    public void initRSAKey() {
        this.rsaPrivateKey = this.createJWTSigningKey();
        this.rsaPublicKey = this.createJWTValidationKey();
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        if (this.rsaPublicKey == null) {
            throw new IllegalArgumentException("RSA public key can't be null");
        }
        return NimbusJwtDecoder.withPublicKey((RSAPublicKey)this.rsaPublicKey).build();
    }

    public RSAPrivateKey createJWTSigningKey() {
        try {
            Key key = this.createKeyStore().getKey(this.keyAlias, this.privateKeyPassphrase.toCharArray());
            if (key instanceof RSAPrivateKey) {
                return (RSAPrivateKey)key;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error("Unable to load private key from keystore: {}", (Object)this.keyStorePath, (Object)e);
        }
        throw new IllegalArgumentException("Unable to load private key");
    }

    public RSAPublicKey createJWTValidationKey() {
        try {
            Certificate certificate = this.createKeyStore().getCertificate(this.keyAlias);
            PublicKey publicKey = certificate.getPublicKey();
            if (publicKey instanceof RSAPublicKey) {
                return (RSAPublicKey)publicKey;
            }
        }
        catch (KeyStoreException e) {
            log.error("Unable to load private key from keystore: {}", (Object)this.keyStorePath, (Object)e);
        }
        throw new IllegalArgumentException("Unable to load RSA public key");
    }

    private KeyStore createKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keyStorePath);
            keyStore.load(resourceAsStream, this.keyStorePassword.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Unable to load keystore: {}", (Object)this.keyStorePath, (Object)e);
            throw new IllegalArgumentException("Unable to load keystore");
        }
    }

    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Generated
    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    @Generated
    public RSAPrivateKey getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    @Generated
    public RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }
}

