/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AuthenticatedMember;
import io.featureprobe.api.auth.JwtConfiguration;
import io.featureprobe.api.auth.JwtHelper;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dto.CertificationUserResponse;
import io.featureprobe.api.service.OrganizationService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class LoginSuccessHandler
implements AuthenticationSuccessHandler {
    private final OrganizationService organizationService;
    private final JwtConfiguration jwtConfiguration;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        UserPasswordAuthenticationToken token = (UserPasswordAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        AuthenticatedMember principal = token.getPrincipal();
        List<OrganizationMemberModel> organizations = this.getOrganizationMemberModels(principal);
        OrganizationMemberModel organizationMember = principal.getOrganizationMemberModel();
        String jwt = JwtHelper.createJwtForMember(this.jwtConfiguration, principal, organizations, organizationMember.getRoleName());
        response.getWriter().write(new CertificationUserResponse(token.getAccount(), organizationMember.getRoleName(), organizationMember.getOrganizationId(), jwt).toJSONString());
    }

    private List<OrganizationMemberModel> getOrganizationMemberModels(AuthenticatedMember principal) {
        ArrayList<OrganizationMemberModel> organizations = new ArrayList<OrganizationMemberModel>();
        for (Organization organization : principal.getOrganizations()) {
            OrganizationMemberModel organizationMemberModel = this.organizationService.queryOrganizationMember(organization.getId(), principal.getId());
            organizations.add(organizationMemberModel);
        }
        return organizations;
    }

    @Generated
    public LoginSuccessHandler(OrganizationService organizationService, JwtConfiguration jwtConfiguration) {
        this.organizationService = organizationService;
        this.jwtConfiguration = jwtConfiguration;
    }
}

