/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccessTokenAuthenticationProcessingFilter;
import io.featureprobe.api.auth.AccessTokenAuthenticationProvider;
import io.featureprobe.api.auth.GuestAuthenticationProcessingFilter;
import io.featureprobe.api.auth.GuestAuthenticationProvider;
import io.featureprobe.api.auth.LoginFailureHandler;
import io.featureprobe.api.auth.LoginSuccessHandler;
import io.featureprobe.api.auth.UserPasswordAuthenticationProcessingFilter;
import io.featureprobe.api.auth.UserPasswordAuthenticationProvider;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.config.JWTConfig;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private LoginFailureHandler loginFailureHandler;
    private LoginSuccessHandler loginSuccessHandler;
    private JWTConfig jwtConfig;
    private UserPasswordAuthenticationProvider userPasswordAuthenticationProvider;
    private GuestAuthenticationProvider guestAuthenticationProvider;
    private AccessTokenAuthenticationProvider accessTokenAuthenticationProvider;

    UserPasswordAuthenticationProcessingFilter userPasswordAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        UserPasswordAuthenticationProcessingFilter userPasswordAuthenticationProcessingFilter = new UserPasswordAuthenticationProcessingFilter();
        userPasswordAuthenticationProcessingFilter.setAuthenticationManager(authenticationManager);
        userPasswordAuthenticationProcessingFilter.setAuthenticationSuccessHandler(this.loginSuccessHandler);
        userPasswordAuthenticationProcessingFilter.setAuthenticationFailureHandler(this.loginFailureHandler);
        return userPasswordAuthenticationProcessingFilter;
    }

    GuestAuthenticationProcessingFilter guestAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        GuestAuthenticationProcessingFilter guestAuthenticationProcessingFilter = new GuestAuthenticationProcessingFilter();
        guestAuthenticationProcessingFilter.setAuthenticationManager(authenticationManager);
        guestAuthenticationProcessingFilter.setAuthenticationFailureHandler(this.loginFailureHandler);
        guestAuthenticationProcessingFilter.setAuthenticationSuccessHandler(this.loginSuccessHandler);
        return guestAuthenticationProcessingFilter;
    }

    AccessTokenAuthenticationProcessingFilter accessTokenAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        AccessTokenAuthenticationProcessingFilter accessTokenAuthenticationProcessingFilter = new AccessTokenAuthenticationProcessingFilter();
        accessTokenAuthenticationProcessingFilter.setAuthenticationManager(authenticationManager);
        accessTokenAuthenticationProcessingFilter.setAuthenticationFailureHandler(this.loginFailureHandler);
        return accessTokenAuthenticationProcessingFilter;
    }

    @Bean
    AuthenticationEntryPoint authenticationEntryPoint() {
        AuthenticationEntryPoint authenticationEntryPoint = (httpServletRequest, httpServletResponse, e) -> {
            BaseResponse res = new BaseResponse(HttpStatus.UNAUTHORIZED.name().toLowerCase(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
            httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.getWriter().write(JsonMapper.toJSONString((Object)res));
        };
        return authenticationEntryPoint;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().frameOptions().disable();
        http.csrf().disable();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((FormLoginConfigurer)http.formLogin().loginProcessingUrl("/api/login")).and()).authorizeRequests().antMatchers(new String[]{"/internal/**", "/api/login", "/api/guestLogin", "/api/v3/api-docs.yaml", "/api/application/**", "/api/public/**"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().and()).exceptionHandling().accessDeniedHandler((httpServletRequest, httpServletResponse, e) -> httpServletResponse.setStatus(HttpStatus.UNAUTHORIZED.value())).authenticationEntryPoint(this.authenticationEntryPoint());
        http.addFilterBefore((Filter)this.userPasswordAuthenticationProcessingFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class);
        if (!this.jwtConfig.isGuestDisabled()) {
            http.addFilterBefore((Filter)this.guestAuthenticationProcessingFilter(this.authenticationManager()), UserPasswordAuthenticationProcessingFilter.class);
        }
        http.addFilterBefore((Filter)this.accessTokenAuthenticationProcessingFilter(this.authenticationManager()), UserPasswordAuthenticationProcessingFilter.class);
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)this.authenticationConverter());
    }

    protected AuthenticationManager authenticationManager() {
        ProviderManager authenticationManager = new ProviderManager(Arrays.asList(this.userPasswordAuthenticationProvider, this.guestAuthenticationProvider, this.accessTokenAuthenticationProvider));
        return authenticationManager;
    }

    protected JwtAuthenticationConverter authenticationConverter() {
        JwtGrantedAuthoritiesConverter authoritiesConverter = new JwtGrantedAuthoritiesConverter();
        authoritiesConverter.setAuthorityPrefix("");
        authoritiesConverter.setAuthoritiesClaimName("role");
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter((Converter)authoritiesConverter);
        return converter;
    }

    @Generated
    public SecurityConfig(LoginFailureHandler loginFailureHandler, LoginSuccessHandler loginSuccessHandler, JWTConfig jwtConfig, UserPasswordAuthenticationProvider userPasswordAuthenticationProvider, GuestAuthenticationProvider guestAuthenticationProvider, AccessTokenAuthenticationProvider accessTokenAuthenticationProvider) {
        this.loginFailureHandler = loginFailureHandler;
        this.loginSuccessHandler = loginSuccessHandler;
        this.jwtConfig = jwtConfig;
        this.userPasswordAuthenticationProvider = userPasswordAuthenticationProvider;
        this.guestAuthenticationProvider = guestAuthenticationProvider;
        this.accessTokenAuthenticationProvider = accessTokenAuthenticationProvider;
    }
}

