/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccountValidator;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import io.featureprobe.api.base.component.SpringBeanManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserPasswordAuthenticationProvider
implements AuthenticationProvider {
    @Value(value="${app.security.validator.impl:common}")
    private String validatorName;

    @Transactional(rollbackFor={Exception.class})
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AccountValidator validator = (AccountValidator)SpringBeanManager.getBeanByName((String)this.validatorName);
        return validator.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return UserPasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

