/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.builder;

import com.featureprobe.sdk.server.model.Condition;
import com.featureprobe.sdk.server.model.ConditionType;
import com.featureprobe.sdk.server.model.Segment;
import com.featureprobe.sdk.server.model.SegmentRule;
import io.featureprobe.api.base.model.SegmentRuleModel;
import io.featureprobe.api.base.util.DateTimeTranslateUtil;
import io.featureprobe.api.base.util.JsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ServerSegmentBuilder {
    private static final String DATETIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private Segment segment;
    private List<SegmentRuleModel> segmentRuleModels;

    public ServerSegmentBuilder builder() {
        this.segment = new Segment();
        return this;
    }

    public ServerSegmentBuilder uniqueId(String uniqueId) {
        this.segment.setUniqueId(uniqueId);
        return this;
    }

    public ServerSegmentBuilder version(Long version) {
        this.segment.setVersion(version);
        return this;
    }

    public ServerSegmentBuilder rules(String rules) {
        this.segmentRuleModels = JsonMapper.toListObject((String)rules, SegmentRuleModel.class);
        return this;
    }

    public Segment build() {
        this.setRules();
        return this.segment;
    }

    private void setRules() {
        if (CollectionUtils.isEmpty(this.segmentRuleModels)) {
            this.segment.setRules(Collections.emptyList());
            return;
        }
        List<SegmentRule> rules = this.segmentRuleModels.stream().map(segmentRuleModel -> segmentRuleModel.toSegmentRule()).collect(Collectors.toList());
        rules.forEach(rule -> rule.getConditions().forEach(condition -> {
            if (condition.getType() == ConditionType.DATETIME) {
                this.convertDatetimeToUnix((Condition)condition);
            }
        }));
        this.segment.setRules(rules);
    }

    private void convertDatetimeToUnix(Condition condition) {
        condition.setObjects(condition.getObjects().stream().map(datetime -> DateTimeTranslateUtil.translateUnix((String)datetime, (String)DATETIME_FORMAT_PATTERN)).collect(Collectors.toList()));
    }
}

