/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.builder;

import com.featureprobe.sdk.server.model.Condition;
import com.featureprobe.sdk.server.model.ConditionType;
import com.featureprobe.sdk.server.model.Rule;
import com.featureprobe.sdk.server.model.Toggle;
import com.google.common.collect.Maps;
import io.featureprobe.api.base.exception.ServerToggleBuildException;
import io.featureprobe.api.base.model.TargetingContent;
import io.featureprobe.api.base.model.Variation;
import io.featureprobe.api.base.util.DateTimeTranslateUtil;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.Segment;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class ServerToggleBuilder {
    private static final String DATETIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private Toggle toggle;
    private Variation.ValueConverter variationValueConverter;
    private TargetingContent targetingContent;
    private Map<String, Segment> segments;
    private static final Map<String, Variation.ValueConverter<?>> converters = Maps.newHashMap();

    public ServerToggleBuilder builder() {
        this.toggle = new Toggle();
        return this;
    }

    public ServerToggleBuilder trackAccessEvents(boolean trackAccessEvents) {
        this.toggle.setTrackAccessEvents(Boolean.valueOf(trackAccessEvents));
        return this;
    }

    public ServerToggleBuilder lastModified(Date lastModified) {
        this.toggle.setLastModified(Objects.isNull(lastModified) ? null : Long.valueOf(lastModified.getTime()));
        return this;
    }

    public ServerToggleBuilder key(String key) {
        this.toggle.setKey(key);
        return this;
    }

    public ServerToggleBuilder version(Long version) {
        this.toggle.setVersion(version);
        return this;
    }

    public ServerToggleBuilder disabled(boolean disabled) {
        this.toggle.setEnabled(Boolean.valueOf(!disabled));
        return this;
    }

    public ServerToggleBuilder forClient(Boolean forClient) {
        this.toggle.setForClient(forClient);
        return this;
    }

    public ServerToggleBuilder rules(String rules) {
        this.targetingContent = (TargetingContent)JsonMapper.toObject((String)rules, TargetingContent.class);
        return this;
    }

    public ServerToggleBuilder segments(Map<String, Segment> segments) {
        this.segments = segments;
        return this;
    }

    public ServerToggleBuilder returnType(String returnType) {
        this.variationValueConverter = this.getReturnTypeConverter(returnType);
        return this;
    }

    private Variation.ValueConverter<?> getReturnTypeConverter(String type) {
        if (converters.containsKey(type.toLowerCase())) {
            return converters.get(type.toLowerCase());
        }
        throw new ServerToggleBuildException("return type is unknown:" + type);
    }

    public Toggle build() {
        this.setDisabledServe();
        this.setDefaultServe();
        this.setVariations();
        this.setPrerequisite();
        this.setRules();
        return this.toggle;
    }

    private ServerToggleBuilder setDisabledServe() {
        if (this.targetingContent.getDisabledServe() == null) {
            throw new ServerToggleBuildException("disabled serve is null");
        }
        this.toggle.setDisabledServe(this.targetingContent.getDisabledServe().toServe());
        return this;
    }

    private void setDefaultServe() {
        if (this.targetingContent.getDefaultServe() != null) {
            this.toggle.setDefaultServe(this.targetingContent.getDefaultServe().toServe());
        }
        if (this.toggle.getDefaultServe() == null && BooleanUtils.isFalse((Boolean)this.toggle.getEnabled()) && this.targetingContent.getDisabledServe() != null) {
            this.toggle.setDefaultServe(this.targetingContent.getDisabledServe().toServe());
        }
        if (this.toggle.getDefaultServe() == null) {
            throw new ServerToggleBuildException("default serve is null");
        }
    }

    private void setVariations() {
        if (this.variationValueConverter == null) {
            throw new ServerToggleBuildException("return type not set");
        }
        List variations = this.targetingContent.getVariationObjectsByConverter(this.variationValueConverter);
        this.toggle.setVariations(variations);
    }

    private void setPrerequisite() {
        if (this.variationValueConverter == null) {
            throw new ServerToggleBuildException("return type not set");
        }
        List prerequisites = this.targetingContent.getPrerequisiteByConverter(converters);
        this.toggle.setPrerequisites(prerequisites);
    }

    private void setRules() {
        if (CollectionUtils.isEmpty((Collection)this.targetingContent.getRules())) {
            this.toggle.setRules(Collections.emptyList());
            return;
        }
        List<Rule> rules = this.targetingContent.getRules().stream().map(rule -> rule.toRule()).collect(Collectors.toList());
        rules.forEach(rule -> rule.getConditions().forEach(condition -> {
            if (condition.getType() == ConditionType.SEGMENT) {
                this.replaceSegmentKeyToUniqueKey((Condition)condition);
            } else if (condition.getType() == ConditionType.DATETIME) {
                this.convertDatetimeToUnix((Condition)condition);
            }
        }));
        this.toggle.setRules(rules);
    }

    private void convertDatetimeToUnix(Condition condition) {
        condition.setObjects(condition.getObjects().stream().map(datetime -> DateTimeTranslateUtil.translateUnix((String)datetime, (String)DATETIME_FORMAT_PATTERN)).collect(Collectors.toList()));
    }

    private void replaceSegmentKeyToUniqueKey(Condition condition) {
        condition.setObjects(condition.getObjects().stream().map(segmentKey -> this.segments.get(segmentKey).getUniqueKey()).collect(Collectors.toList()));
    }

    static {
        converters.put("string", value -> value);
        converters.put("boolean", value -> Boolean.valueOf(value));
        converters.put("json", value -> (Map)JsonMapper.toObject((String)value, Map.class));
        converters.put("number", value -> new BigDecimal(value));
    }
}

