/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.CreateApiResponse;
import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.DeleteApiResponse;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.doc.PatchApiResponse;
import io.featureprobe.api.base.hook.Action;
import io.featureprobe.api.base.hook.Hook;
import io.featureprobe.api.base.hook.Resource;
import io.featureprobe.api.dto.SecretKeyResponse;
import io.featureprobe.api.dto.WebHookCreateRequest;
import io.featureprobe.api.dto.WebHookItemResponse;
import io.featureprobe.api.dto.WebHookListRequest;
import io.featureprobe.api.dto.WebHookResponse;
import io.featureprobe.api.dto.WebHookUpdateRequest;
import io.featureprobe.api.service.WebHookService;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Webhooks", description="The webhooks API allows you to list, create, modify, \" +\n        \"query and delete WebHook programmatically.")
@RequestMapping(value={"/api/webhooks"})
@DefaultApiResponses
@ResourceExistsValidate
@RestController
public class WebHookController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebHookController.class);
    private WebHookService webHookService;

    @CreateApiResponse
    @PostMapping
    @Operation(summary="Create webhook", description="Create a new webhook.")
    @Hook(resource=Resource.WEBHOOK, action=Action.CREATE)
    public WebHookResponse create(@Validated @RequestBody WebHookCreateRequest createRequest) {
        return this.webHookService.create(createRequest);
    }

    @PatchApiResponse
    @PatchMapping(value={"/{id}"})
    @Operation(summary="Update webhook", description="Update a webhook.")
    @Hook(resource=Resource.WEBHOOK, action=Action.UPDATE)
    public WebHookResponse update(@PathVariable(name="id") Long id, @Validated @RequestBody WebHookUpdateRequest updateRequest) {
        return this.webHookService.update(id, updateRequest);
    }

    @DeleteApiResponse
    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete webhook", description="Delete a webhook.")
    @Hook(resource=Resource.WEBHOOK, action=Action.DELETE)
    public WebHookResponse delete(@PathVariable(name="id") @Schema(description="The ID of the webhook.") Long id) {
        return this.webHookService.delete(id);
    }

    @GetApiResponse
    @GetMapping(value={"/{id}"})
    @Operation(summary="Get WebHook", description="Get a single webhook flag by id.")
    public WebHookItemResponse query(@PathVariable(name="id") @Schema(description="The ID of the webhook.") Long id) {
        return this.webHookService.query(id);
    }

    @GetApiResponse
    @GetMapping(value={"/secretKey"})
    @Operation(summary="Get WebHook SecretKey", description="Get a system-suggested secret key.")
    public SecretKeyResponse secretKey() {
        return this.webHookService.secretKey();
    }

    @GetApiResponse
    @GetMapping
    @Operation(summary="List WebHook", description="Get a list of all WebHook.")
    public Page<WebHookItemResponse> list(@Validated WebHookListRequest listRequest) {
        return this.webHookService.list(listRequest);
    }

    @GetApiResponse
    @GetMapping(value={"/checkUrl"})
    @Operation(summary="Get webhook names", description="Get the webhook names of the same url.")
    public List<String> queryByUrl(@RequestParam(name="url") @Schema(description="The url of the webhook.") String url) {
        return this.webHookService.queryByUrl(url);
    }

    @Generated
    public WebHookController(WebHookService webHookService) {
        this.webHookService = webHookService;
    }
}

