/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.event.listener;

import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.config.AppConfig;
import io.featureprobe.api.event.ToggleChangeEvent;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ToggleChangeEventListener
implements ApplicationListener<ToggleChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToggleChangeEventListener.class);
    private AppConfig appConfig;
    private static final String CHANGE_API_PATH = "/internal/update_toggles";
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(Duration.ofSeconds(3L)).readTimeout(Duration.ofSeconds(3L)).writeTimeout(Duration.ofSeconds(3L)).retryOnConnectionFailure(true).build();

    public void onApplicationEvent(ToggleChangeEvent event) {
        String[] serverBaseUrls;
        String[] stringArray = serverBaseUrls = Objects.isNull(this.appConfig.getServerBaseUrls()) ? null : this.appConfig.getServerBaseUrls().split(",");
        if (Objects.nonNull(serverBaseUrls)) {
            for (String serverUrl : serverBaseUrls) {
                this.pushChange(serverUrl + CHANGE_API_PATH, event.getServerSdkKey());
            }
        }
    }

    public boolean pushChange(String serverUrl, String sdkKey) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sdk_key", sdkKey);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JsonMapper.toJSONString(params));
            Request request = new Request.Builder().url(serverUrl).post(body).build();
            Response response = this.httpClient.newCall(request).execute();
            log.info("toggle update notice -- {}", (Object)response);
            return response.isSuccessful();
        }
        catch (IOException e) {
            log.error("Toggle change server notice error", (Throwable)e);
            return false;
        }
    }

    @Generated
    public ToggleChangeEventListener(AppConfig appConfig) {
        this.appConfig = appConfig;
    }
}

