/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.event.listener;

import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.WebHookCallbackStatus;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.dao.entity.WebHookSettings;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.WebHookSettingsRepository;
import io.featureprobe.api.event.WebHookPostEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class WebHookPostEventListener
implements ApplicationListener<WebHookPostEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebHookPostEventListener.class);
    private WebHookSettingsRepository settingsRepository;

    public void onApplicationEvent(WebHookPostEvent event) {
        WebHookSettings webHookSettings = (WebHookSettings)this.settingsRepository.findByOrganizationIdAndName(event.getOrganizationId(), event.getName()).orElseThrow(() -> new ResourceNotFoundException(ResourceType.WEBHOOK, event.getOrganizationId() + "-" + event.getName()));
        webHookSettings.setLastedTime(event.getCallbackResult().getTime());
        webHookSettings.setLastedStatus(event.getCallbackResult().isSuccess() ? WebHookCallbackStatus.SUCCESS.name() : WebHookCallbackStatus.FAIL.name());
        webHookSettings.setLastedStatusCode(Integer.valueOf(event.getCallbackResult().getStatusCode()));
        TenantContext.setCurrentTenant((String)String.valueOf(event.getOrganizationId()));
        this.settingsRepository.save((Object)webHookSettings);
    }

    @Generated
    public WebHookPostEventListener(WebHookSettingsRepository settingsRepository) {
        this.settingsRepository = settingsRepository;
    }
}

