/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.filter;

import io.featureprobe.api.auth.OrganizationEmptyException;
import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.config.JWTConfig;
import io.featureprobe.api.service.OrganizationService;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class TenantFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantFilter.class);
    private static final String TENANT_HEADER = "X-OrganizeID";
    private static final String ORGANIZATION_ID_MISS_ERROR_MSG = "No OrganizationID supplied";
    private OrganizationService organizationService;
    private JWTConfig JWTConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestURI = request.getRequestURI();
        if (!this.pass(requestURI)) {
            String tenantHeader = request.getHeader(TENANT_HEADER);
            try {
                OrganizationMemberModel organizationMemberModel;
                if (StringUtils.isBlank((CharSequence)tenantHeader)) {
                    tenantHeader = TenantContext.getCurrentTenant();
                }
                if (StringUtils.isNotBlank((CharSequence)tenantHeader)) {
                    organizationMemberModel = this.organizationService.queryOrganizationMember(Long.parseLong(tenantHeader), TokenHelper.getUserId());
                    if (Objects.isNull(organizationMemberModel)) {
                        throw new OrganizationEmptyException("User has no access to the organization.");
                    }
                } else {
                    this.tenantErrorResponse(response);
                    return;
                }
                TenantContext.setCurrentTenant((String)tenantHeader);
                TenantContext.setCurrentOrganization((OrganizationMemberModel)organizationMemberModel);
            }
            catch (Exception e) {
                log.error("member not in the organization.", (Throwable)e);
                this.organizationErrorResponse(response);
            }
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            TenantContext.clear();
        }
    }

    private boolean pass(String uri) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : this.JWTConfig.getExcludeTenantUri()) {
            if (matcher.match("/api/**", uri) && !matcher.match(pattern, uri)) continue;
            return true;
        }
        return false;
    }

    private void tenantErrorResponse(HttpServletResponse response) throws IOException {
        BaseResponse res = new BaseResponse(HttpStatus.BAD_REQUEST.name().toLowerCase(), ORGANIZATION_ID_MISS_ERROR_MSG);
        response.setStatus(400);
        response.setContentType("application/json");
        response.getWriter().write(JsonMapper.toJSONString((Object)res));
        response.getWriter().flush();
    }

    private void organizationErrorResponse(HttpServletResponse response) throws IOException {
        BaseResponse res = new BaseResponse(HttpStatus.FORBIDDEN.name().toLowerCase(), HttpStatus.FORBIDDEN.getReasonPhrase());
        response.setStatus(401);
        response.setContentType("application/json");
        response.getWriter().write(JsonMapper.toJSONString((Object)res));
        response.getWriter().flush();
    }

    @Generated
    public TenantFilter(OrganizationService organizationService, JWTConfig JWTConfig2) {
        this.organizationService = organizationService;
        this.JWTConfig = JWTConfig2;
    }
}

