/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.hook;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.featureprobe.api.base.hook.HookSettingsStatus;
import io.featureprobe.api.base.hook.ICallback;
import io.featureprobe.api.base.hook.IHookQueue;
import io.featureprobe.api.base.hook.IHookRuleBuilder;
import io.featureprobe.api.base.model.HookContext;
import io.featureprobe.api.dao.entity.WebHookSettings;
import io.featureprobe.api.dao.repository.WebHookSettingsRepository;
import io.featureprobe.api.hook.CallbackAbilityContainer;
import io.featureprobe.api.hook.WebHook;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class HookProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookProcessor.class);
    private final WebHookSettingsRepository webHookSettingsRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final IHookRuleBuilder hookRuleBuilder;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FeatureProbe-API-Hook-Processor-%d").setPriority(1).build();

    public HookProcessor(IHookQueue hookQueue, WebHookSettingsRepository webHookSettingsRepository, ApplicationEventPublisher eventPublisher, IHookRuleBuilder hookRuleBuilder) {
        this.webHookSettingsRepository = webHookSettingsRepository;
        this.eventPublisher = eventPublisher;
        this.hookRuleBuilder = hookRuleBuilder;
        Thread hookProcessorThread = this.threadFactory.newThread(() -> this.handleHook(hookQueue));
        hookProcessorThread.setDaemon(true);
        hookProcessorThread.start();
    }

    private void handleHook(IHookQueue hookQueue) {
        while (!this.closed.get()) {
            try {
                HookContext hookContext = hookQueue.take();
                List webHookSettingsList = this.webHookSettingsRepository.findAllByOrganizationIdAndStatus(hookContext.getOrganizationId(), HookSettingsStatus.ENABLE);
                List webHooks = webHookSettingsList.stream().map(webHookSettings -> this.translateHookConfig((WebHookSettings)webHookSettings)).filter(x -> x != null).collect(Collectors.toList());
                for (WebHook webHook : webHooks) {
                    webHook.callback(hookContext, this.eventPublisher);
                }
            }
            catch (Exception e) {
                log.error("FeatureProbe hook process error", (Throwable)e);
            }
        }
    }

    private WebHook translateHookConfig(WebHookSettings webHookSettings) {
        WebHook webHook = new WebHook();
        webHook.setName(webHookSettings.getName());
        webHook.setUrl(webHookSettings.getUrl());
        webHook.setOrganizationId(webHookSettings.getOrganizationId());
        webHook.setRule(this.hookRuleBuilder.build(webHookSettings.getId()));
        webHook.setSecretKey(webHookSettings.getSecretKey());
        ICallback callback = CallbackAbilityContainer.get(webHookSettings.getType());
        if (Objects.isNull(callback)) {
            return null;
        }
        webHook.setHook(callback);
        return webHook;
    }
}

