/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dto.ApprovalSettings;
import io.featureprobe.api.dto.ApprovalSettingsResponse;
import io.featureprobe.api.dto.EnvironmentCreateRequest;
import io.featureprobe.api.dto.EnvironmentResponse;
import io.featureprobe.api.dto.EnvironmentUpdateRequest;
import io.featureprobe.api.mapper.EnvironmentMapper;

public class EnvironmentMapperImpl
implements EnvironmentMapper {
    @Override
    public EnvironmentResponse entityToResponse(Environment environment) {
        if (environment == null) {
            return null;
        }
        EnvironmentResponse environmentResponse = new EnvironmentResponse();
        environmentResponse.setName(environment.getName());
        environmentResponse.setKey(environment.getKey());
        environmentResponse.setEnableApproval(environment.isEnableApproval());
        environmentResponse.setServerSdkKey(environment.getServerSdkKey());
        environmentResponse.setClientSdkKey(environment.getClientSdkKey());
        return environmentResponse;
    }

    @Override
    public Environment requestToEntity(EnvironmentCreateRequest createRequest) {
        if (createRequest == null) {
            return null;
        }
        Environment.EnvironmentBuilder environment = Environment.builder();
        environment.name(createRequest.getName());
        environment.key(createRequest.getKey());
        return environment.build();
    }

    @Override
    public ApprovalSettingsResponse entityToApprovalSettingsResponse(Environment environment) {
        if (environment == null) {
            return null;
        }
        ApprovalSettingsResponse approvalSettingsResponse = new ApprovalSettingsResponse();
        approvalSettingsResponse.setEnvironmentKey(environment.getKey());
        approvalSettingsResponse.setEnvironmentName(environment.getName());
        approvalSettingsResponse.setEnable(environment.isEnableApproval());
        approvalSettingsResponse.setReviewers(this.toReviewerList(environment.getReviewers()));
        return approvalSettingsResponse;
    }

    @Override
    public void mapEntity(EnvironmentUpdateRequest updateRequest, Environment environment) {
        if (updateRequest == null) {
            return;
        }
        if (updateRequest.getName() != null) {
            environment.setName(updateRequest.getName());
        }
    }

    @Override
    public void mapEntity(ApprovalSettings approvalSettings, Environment environment) {
        if (approvalSettings == null) {
            return;
        }
        if (approvalSettings.getEnable() != null) {
            environment.setEnableApproval(approvalSettings.getEnable().booleanValue());
        }
        environment.setReviewers(this.toReviewers(approvalSettings.getReviewers()));
    }
}

